/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.edac;

import io.github.dsheirer.bits.BinaryMessage;
import io.github.dsheirer.bits.CorrectedBinaryMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Golay24 {
    private static final Logger mLog = LoggerFactory.getLogger(Golay24.class);
    public static final int[] CHECKSUMS = new int[]{1594, 797, 1972, 986, 493, 1740, 870, 435, 1763, 1355, 1183, 1141, 1024, 512, 256, 128, 64, 32, 16, 8, 4, 2, 1};

    private static int calculateChecksum(BinaryMessage message, int startIndex) {
        int calculated = 0;
        int i = message.nextSetBit(startIndex);
        while (i >= startIndex && i < startIndex + 12) {
            calculated ^= CHECKSUMS[i - startIndex];
            i = message.nextSetBit(i + 1);
        }
        return calculated;
    }

    public static int checkAndCorrect(CorrectedBinaryMessage message, int startIndex) {
        boolean parityError = message.cardinality() % 2 != 0;
        int syndrome = Golay24.getSyndrome(message, startIndex);
        if (syndrome == 0) {
            if (parityError) {
                message.flip(startIndex + 23);
                message.incrementCorrectedBitCount(1);
                return 1;
            }
            return 0;
        }
        int original = message.getInt(0, 22);
        int index = -1;
        int syndromeWeight = 3;
        int errors = 0;
        while (index < 23) {
            if (index != -1) {
                if (index > 0) {
                    message.flip(index - 1);
                }
                message.flip(index);
                syndromeWeight = 2;
            }
            if ((syndrome = Golay24.getSyndrome(message, startIndex)) <= 0) continue;
            for (int i = 0; i < 23; ++i) {
                errors = Integer.bitCount(syndrome);
                if (errors <= syndromeWeight) {
                    int corrected;
                    message.xor(12, 11, syndrome);
                    message.rotateRight(i, startIndex, startIndex + 22);
                    if (index >= 0) {
                        ++errors;
                    }
                    if (Integer.bitCount(original ^ (corrected = message.getInt(0, 22))) > 3) {
                        return 2;
                    }
                    return 1;
                }
                message.rotateLeft(startIndex, startIndex + 22);
                syndrome = Golay24.getSyndrome(message, startIndex);
            }
            ++index;
        }
        return 2;
    }

    private static int getSyndrome(BinaryMessage message, int startIndex) {
        int calculated = Golay24.calculateChecksum(message, startIndex);
        int checksum = message.getInt(startIndex + 12, startIndex + 22);
        return checksum ^ calculated;
    }

    public static void main(String[] args) {
        CorrectedBinaryMessage bm = new CorrectedBinaryMessage(BinaryMessage.loadHex("AFAC00"));
        System.out.println("M:" + bm.toHexString());
        int a = Golay24.checkAndCorrect(bm, 0);
        System.out.println("M:" + bm.toHexString());
        System.out.println("A:" + a);
    }
}

