/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.edac;

import io.github.dsheirer.bits.BinaryMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CRCUtil {
    private static final Logger mLog = LoggerFactory.getLogger(CRCUtil.class);

    public static long[] generate(int messageSize, int crcSize, long polynomial, long initialFill, boolean includeCRCBitErrors) {
        int x;
        long[] crcTable = new long[messageSize + (includeCRCBitErrors ? crcSize : 0)];
        int[] checksumIndexes = new int[crcSize];
        for (x = 0; x < crcSize; ++x) {
            checksumIndexes[x] = messageSize + x;
        }
        for (x = 0; x < messageSize; ++x) {
            long checksum;
            BinaryMessage message = new BinaryMessage(messageSize + crcSize);
            message.load(messageSize, crcSize, initialFill);
            message.set(x);
            message = CRCUtil.decode(message, 0, messageSize, polynomial, crcSize);
            crcTable[x] = checksum = message.getLong(checksumIndexes);
        }
        if (includeCRCBitErrors) {
            for (x = 0; x < crcSize; ++x) {
                crcTable[messageSize + x] = Long.rotateLeft(1L, x);
            }
        }
        return crcTable;
    }

    public static long[] generate(int messageSize, int crcSize, long polynomial, long initialFill, boolean includeCRCBitErrors, Parity parity) {
        long[] table = CRCUtil.generate(messageSize, crcSize, polynomial, initialFill, includeCRCBitErrors);
        if (parity == Parity.NONE) {
            return table;
        }
        for (int x = 0; x < table.length; ++x) {
            int n = x;
            table[n] = table[n] << 1;
            if (CRCUtil.parity(table[x]) == parity) continue;
            int n2 = x;
            table[n2] = table[n2] ^ 1L;
        }
        return table;
    }

    public static Parity parity(long value) {
        return Long.bitCount(value) % 2 == 0 ? Parity.EVEN : Parity.ODD;
    }

    public static BinaryMessage decode(BinaryMessage message, int messageStart, int messageSize, long polynomial, int crcSize) {
        int i = message.nextSetBit(messageStart);
        while (i >= messageStart && i < messageSize) {
            BinaryMessage polySet = new BinaryMessage(crcSize + i + 1);
            polySet.load(i, crcSize + 1, polynomial);
            message.xor(polySet);
            System.out.println(message.toString());
            i = message.nextSetBit(i + 1);
        }
        return message;
    }

    public static String toCodeArray(long[] values) {
        boolean integerArray = true;
        for (long value : values) {
            if (value <= Integer.MAX_VALUE && value >= Integer.MIN_VALUE) continue;
            integerArray = false;
            break;
        }
        StringBuilder sb = new StringBuilder();
        if (integerArray) {
            sb.append("\npublic static final int[] CHECKSUMS = new int[]\n");
        } else {
            sb.append("\npublic static final long[] CHECKSUMS = new long[]\n");
        }
        sb.append("{\n");
        StringBuilder row = new StringBuilder();
        row.append("    ");
        for (long value : values) {
            StringBuilder element = new StringBuilder();
            element.append("0x");
            element.append(Long.toHexString(value).toUpperCase());
            if (!integerArray) {
                element.append("l");
            }
            element.append(", ");
            if (row.length() + element.length() <= 80) {
                row.append(element.toString());
                continue;
            }
            sb.append(row.toString());
            sb.append("\n");
            row = new StringBuilder();
            row.append("    ");
            row.append(element.toString());
        }
        if (row.length() > 4) {
            sb.append(row.toString());
            sb.append("\n");
        }
        sb.append("};\n");
        return sb.toString();
    }

    public static void main(String[] args) {
        mLog.debug("Starting");
        long poly = 19L;
        long[] checksums = CRCUtil.generate(32, 4, poly, 0L, true);
        StringBuilder sb = new StringBuilder();
        sb.append("private static int[] CHECKSUMS = new int[]{");
        for (long checksum : checksums) {
            sb.append("0x").append(Long.toHexString(checksum).toUpperCase());
            sb.append(",");
        }
        sb.append("};");
        System.out.println("Checksums:\n" + String.valueOf(sb));
    }

    public static enum Parity {
        EVEN,
        ODD,
        NONE;

    }
}

