/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.edac;

import io.github.dsheirer.edac.CRC;
import io.github.dsheirer.message.MessageDirection;
import java.util.BitSet;

public class CRCLTR {
    private static byte[] sCHECKSUMS = new byte[]{56, 28, 14, 70, 35, 81, 104, 117, 122, 61, 31, 79, 38, 82, 41, 21, 11, 69, 98, 49, 25, 13, 7, 67};

    public static CRC check(BitSet msg, MessageDirection direction) {
        CRC crc = CRC.UNKNOWN;
        int calculated = CRCLTR.getCalculatedChecksum(msg);
        int transmitted = CRCLTR.getTransmittedChecksum(msg);
        if (direction == MessageDirection.OSW) {
            if (calculated == transmitted) {
                return CRC.PASSED;
            }
        } else {
            if ((calculated ^ 0x7F) == transmitted) {
                return CRC.PASSED_INV;
            }
            if (calculated == transmitted) {
                return CRC.PASSED;
            }
        }
        return CRC.FAILED_CRC;
    }

    public static String getCRCReason(BitSet msg, MessageDirection direction) {
        int calculated = CRCLTR.getCalculatedChecksum(msg);
        int transmitted = CRCLTR.getTransmittedChecksum(msg);
        return "CALC: " + Integer.toHexString(calculated).toUpperCase() + " TRANS: " + Integer.toHexString(transmitted).toUpperCase();
    }

    public static byte[] getChecks() {
        return sCHECKSUMS;
    }

    public static int getCalculatedChecksum(BitSet msg) {
        int calculated = 0;
        int i = msg.nextSetBit(9);
        while (i >= 9 && i < 33) {
            calculated ^= sCHECKSUMS[i - 9];
            i = msg.nextSetBit(i + 1);
        }
        return calculated;
    }

    public static int getTransmittedChecksum(BitSet msg) {
        int retVal = 0;
        for (int x = 0; x < 7; ++x) {
            if (!msg.get(x + 33)) continue;
            retVal += 1 << 6 - x;
        }
        return retVal;
    }

    public static int[] findBitErrors(BitSet msg) {
        int[] retVal = null;
        int checksum = CRCLTR.getTransmittedChecksum(msg);
        checksum ^= 1;
        int i = msg.nextSetBit(0);
        while (i >= 0 && i < 47) {
            checksum ^= sCHECKSUMS[i];
            i = msg.nextSetBit(i + 1);
        }
        if (checksum == 0) {
            msg.flip(62);
        } else {
            for (int x = 0; x < 47; ++x) {
                if (checksum != sCHECKSUMS[x]) continue;
                retVal = new int[]{x};
            }
        }
        return retVal;
    }
}

