/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.edac;

import org.apache.commons.lang3.Validate;
import org.apache.commons.math3.util.FastMath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BerlekempMassey {
    private static final Logger mLog = LoggerFactory.getLogger(BerlekempMassey.class);
    private int MM;
    private int NN;
    private int MAX_NN;
    private int KK;
    int TT;
    int[] alpha_to;
    int[] index_of;
    int[] gg;

    public BerlekempMassey(int galoisFieldSize, int maxCorrectableErrors, int[] generatorPolynomial) {
        this.MM = galoisFieldSize;
        this.NN = (int)FastMath.pow((double)2.0, (int)this.MM) - 1;
        this.TT = maxCorrectableErrors;
        this.KK = this.NN - 2 * this.TT;
    }

    public BerlekempMassey(int bitSize, int n, int k, int[] generatorPolynomial) {
        Validate.isTrue((bitSize == generatorPolynomial.length - 1 ? 1 : 0) != 0, (String)"Generator polynomial length must be: bitSize + 1", (Object[])new Object[0]);
        this.MM = bitSize;
        this.NN = n;
        this.KK = k;
        this.TT = (int)Math.floor((this.NN - this.KK) / 2);
        int maxNN = (int)Math.pow(2.0, this.MM) - 1;
        this.alpha_to = new int[maxNN + 1];
        this.index_of = new int[maxNN + 1];
        this.gg = new int[this.NN - this.KK + 1];
        this.generate_gf(generatorPolynomial);
        this.gen_poly();
    }

    private void generate_gf(int[] generator_polynomial) {
        int i;
        int mask = 1;
        this.alpha_to[this.MM] = 0;
        for (i = 0; i < this.MM; ++i) {
            this.alpha_to[i] = mask;
            this.index_of[this.alpha_to[i]] = i;
            if (generator_polynomial[i] != 0) {
                int n = this.MM;
                this.alpha_to[n] = this.alpha_to[n] ^ mask;
            }
            mask <<= 1;
        }
        this.index_of[this.alpha_to[this.MM]] = this.MM;
        mask >>= 1;
        for (i = this.MM + 1; i < this.NN; ++i) {
            this.alpha_to[i] = this.alpha_to[i - 1] >= mask ? this.alpha_to[this.MM] ^ (this.alpha_to[i - 1] ^ mask) << 1 : this.alpha_to[i - 1] << 1;
            this.index_of[this.alpha_to[i]] = i;
        }
        this.index_of[0] = -1;
    }

    private void gen_poly() {
        int i;
        this.gg[0] = 2;
        this.gg[1] = 1;
        for (i = 2; i <= this.NN - this.KK; ++i) {
            this.gg[i] = 1;
            for (int j = i - 1; j > 0; --j) {
                this.gg[j] = this.gg[j] != 0 ? this.gg[j - 1] ^ this.alpha_to[(this.index_of[this.gg[j]] + i) % this.NN] : this.gg[j - 1];
            }
            this.gg[0] = this.alpha_to[(this.index_of[this.gg[0]] + i) % this.NN];
        }
        for (i = 0; i <= this.NN - this.KK; ++i) {
            this.gg[i] = this.index_of[this.gg[i]];
        }
    }

    public boolean decode(int[] input, int[] output) {
        int j;
        int i;
        int[][] elp = new int[this.NN - this.KK + 2][this.NN - this.KK];
        int[] d = new int[this.NN - this.KK + 2];
        int[] l = new int[this.NN - this.KK + 2];
        int[] u_lu = new int[this.NN - this.KK + 2];
        int[] s = new int[this.NN - this.KK + 1];
        int count = 0;
        boolean syn_error = false;
        int[] root2 = new int[this.TT];
        int[] loc = new int[this.TT];
        int[] z = new int[this.TT + 1];
        int[] err = new int[this.NN];
        int[] reg = new int[this.TT + 1];
        boolean irrecoverable_error = false;
        for (i = 0; i < this.NN; ++i) {
            output[i] = this.index_of[input[i]];
        }
        for (i = 1; i <= this.NN - this.KK; ++i) {
            s[i] = 0;
            for (j = 0; j < this.NN; ++j) {
                if (output[j] == -1) continue;
                int n = i;
                s[n] = s[n] ^ this.alpha_to[(output[j] + i * j) % this.NN];
            }
            if (s[i] != 0) {
                syn_error = true;
            }
            s[i] = this.index_of[s[i]];
        }
        if (syn_error) {
            int q;
            d[0] = 0;
            d[1] = s[1];
            elp[0][0] = 0;
            elp[1][0] = 1;
            for (i = 1; i < this.NN - this.KK; ++i) {
                elp[0][i] = -1;
                elp[1][i] = 0;
            }
            l[0] = 0;
            l[1] = 0;
            u_lu[0] = -1;
            u_lu[1] = 0;
            int u = 0;
            do {
                if (d[++u] == -1) {
                    l[u + 1] = l[u];
                    for (i = 0; i <= l[u]; ++i) {
                        elp[u + 1][i] = elp[u][i];
                        elp[u][i] = this.index_of[elp[u][i]];
                    }
                } else {
                    for (q = u - 1; d[q] == -1 && q > 0; --q) {
                    }
                    if (q > 0) {
                        int j2 = q;
                        do {
                            if (d[--j2] == -1 || u_lu[q] >= u_lu[j2]) continue;
                            q = j2;
                        } while (j2 > 0);
                    }
                    l[u + 1] = FastMath.max((int)l[u], (int)(l[q] + u - q));
                    for (i = 0; i < this.NN - this.KK; ++i) {
                        elp[u + 1][i] = 0;
                    }
                    for (i = 0; i <= l[q]; ++i) {
                        if (elp[q][i] == -1) continue;
                        elp[u + 1][i + u - q] = this.alpha_to[(d[u] + this.NN - d[q] + elp[q][i]) % this.NN];
                    }
                    for (i = 0; i <= l[u]; ++i) {
                        int[] nArray = elp[u + 1];
                        int n = i;
                        nArray[n] = nArray[n] ^ elp[u][i];
                        elp[u][i] = this.index_of[elp[u][i]];
                    }
                }
                u_lu[u + 1] = u - l[u + 1];
                if (u >= this.NN - this.KK) continue;
                d[u + 1] = s[u + 1] != -1 ? this.alpha_to[s[u + 1]] : 0;
                for (i = 1; i <= l[u + 1]; ++i) {
                    if (s[u + 1 - i] == -1 || elp[u + 1][i] == 0) continue;
                    int n = u + 1;
                    d[n] = d[n] ^ this.alpha_to[(s[u + 1 - i] + this.index_of[elp[u + 1][i]]) % this.NN];
                }
                d[u + 1] = this.index_of[d[u + 1]];
            } while (u < this.NN - this.KK && l[u + 1] <= this.TT);
            if (l[++u] <= this.TT) {
                for (i = 0; i <= l[u]; ++i) {
                    elp[u][i] = this.index_of[elp[u][i]];
                }
                if (l[u] >= 0) {
                    System.arraycopy(elp[u], 1, reg, 1, l[u]);
                }
                count = 0;
                for (i = 1; i <= this.NN; ++i) {
                    q = 1;
                    for (j = 1; j <= l[u]; ++j) {
                        if (reg[j] == -1) continue;
                        reg[j] = (reg[j] + j) % this.NN;
                        q ^= this.alpha_to[reg[j]];
                    }
                    if (q != 0) continue;
                    root2[count] = i;
                    loc[count] = this.NN - i;
                    ++count;
                }
                if (count == l[u]) {
                    for (i = 1; i <= l[u]; ++i) {
                        z[i] = s[i] != -1 && elp[u][i] != -1 ? this.alpha_to[s[i]] ^ this.alpha_to[elp[u][i]] : (s[i] != -1 && elp[u][i] == -1 ? this.alpha_to[s[i]] : (s[i] == -1 && elp[u][i] != -1 ? this.alpha_to[elp[u][i]] : 0));
                        for (j = 1; j < i; ++j) {
                            if (s[j] == -1 || elp[u][i - j] == -1) continue;
                            int n = i;
                            z[n] = z[n] ^ this.alpha_to[(elp[u][i - j] + s[j]) % this.NN];
                        }
                        z[i] = this.index_of[z[i]];
                    }
                    for (i = 0; i < this.NN; ++i) {
                        err[i] = 0;
                        output[i] = output[i] != -1 ? this.alpha_to[output[i]] : 0;
                    }
                    for (i = 0; i < l[u]; ++i) {
                        err[loc[i]] = 1;
                        for (j = 1; j <= l[u]; ++j) {
                            if (z[j] == -1) continue;
                            int n = loc[i];
                            err[n] = err[n] ^ this.alpha_to[(z[j] + j * root2[i]) % this.NN];
                        }
                        if (err[loc[i]] == 0) continue;
                        err[loc[i]] = this.index_of[err[loc[i]]];
                        q = 0;
                        for (j = 0; j < l[u]; ++j) {
                            if (j == i) continue;
                            q += this.index_of[1 ^ this.alpha_to[(loc[j] + root2[i]) % this.NN]];
                        }
                        err[loc[i]] = this.alpha_to[(err[loc[i]] - (q %= this.NN) + this.NN) % this.NN];
                        int n = loc[i];
                        output[n] = output[n] ^ err[loc[i]];
                    }
                } else {
                    irrecoverable_error = true;
                }
            } else {
                irrecoverable_error = true;
            }
        } else {
            for (i = 0; i < this.NN; ++i) {
                output[i] = output[i] != -1 ? this.alpha_to[output[i]] : 0;
            }
        }
        if (irrecoverable_error) {
            for (i = 0; i < this.NN; ++i) {
                output[i] = output[i] != -1 ? this.alpha_to[output[i]] : 0;
            }
        }
        return irrecoverable_error;
    }
}

