/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.edac;

import io.github.dsheirer.bits.BinaryMessage;
import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.edac.Hamming16;

public class BPTC_16_2 {
    private static final int[] DEINTERLEAVE = new int[]{0, 24, 1, 25, 2, 26, 3, 27, 4, 28, 5, 29, 6, 30, 7, 31, 8, 16, 9, 17, 10, 18, 11, 19, 12, 20, 13, 21, 14, 22, 15, 23};

    public static CorrectedBinaryMessage decodeShortBurst(CorrectedBinaryMessage message) {
        CorrectedBinaryMessage deinterleaved = BPTC_16_2.deinterleave(message);
        int fec = Hamming16.checkAndCorrect(deinterleaved, 0);
        if (fec == 2) {
            return null;
        }
        for (int x = 0; x < 16; ++x) {
            if (!(deinterleaved.get(x) ^ deinterleaved.get(x + 16))) continue;
            return null;
        }
        return deinterleaved;
    }

    public static CorrectedBinaryMessage decodeReverseChannel(CorrectedBinaryMessage message) {
        CorrectedBinaryMessage deinterleaved = BPTC_16_2.deinterleave(message);
        System.out.println(" DEINTER: " + deinterleaved.toHexString());
        int fec = Hamming16.checkAndCorrect(deinterleaved, 0);
        System.out.println(" DECODED: " + deinterleaved.toHexString());
        System.out.println("FEC:" + fec);
        if (fec == 2) {
            return null;
        }
        for (int x = 0; x < 16; ++x) {
            if (deinterleaved.get(x) != deinterleaved.get(x + 16)) continue;
            return null;
        }
        return deinterleaved;
    }

    public static CorrectedBinaryMessage deinterleave(CorrectedBinaryMessage original) {
        CorrectedBinaryMessage delinterleaved = new CorrectedBinaryMessage(32);
        for (int x = 0; x < 32; ++x) {
            if (!original.get(x)) continue;
            delinterleaved.set(DEINTERLEAVE[x]);
        }
        return delinterleaved;
    }

    public static void main(String[] args) {
        String[] msgs;
        for (String msg : msgs = new String[]{"05030A03", "35003A00", "1C6D2C9E"}) {
            CorrectedBinaryMessage original = new CorrectedBinaryMessage(BinaryMessage.loadHex(msg));
            System.out.println("ORIGINAL: " + original.toHexString());
            CorrectedBinaryMessage decoded = BPTC_16_2.decodeReverseChannel(original);
            System.out.println("-------------------------");
        }
    }
}

