/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.edac;

import io.github.dsheirer.bits.BinaryMessage;
import io.github.dsheirer.edac.CRC;
import io.github.dsheirer.edac.ReedSolomon_63_P25;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BCH_63_16_11
extends ReedSolomon_63_P25 {
    private static final Logger mLog = LoggerFactory.getLogger(BCH_63_16_11.class);

    public BCH_63_16_11() {
        super(63, 41);
    }

    public BinaryMessage correctNID(BinaryMessage message) {
        int[] corrected;
        CRC status = CRC.PASSED;
        int[] original = message.toReverseIntegerArray(0, 62);
        boolean irrecoverableErrors = this.decode(original, corrected = new int[63]);
        if (irrecoverableErrors) {
            message.setCRC(CRC.FAILED_CRC);
            return message;
        }
        for (int x = 0; x < 16; ++x) {
            int index = 63 - x - 1;
            if (corrected[index] == original[index]) continue;
            status = CRC.CORRECTED;
            if (corrected[index] == 1) {
                message.set(x);
                continue;
            }
            message.clear(x);
        }
        message.setCRC(status);
        return message;
    }

    public static void main(String[] args) {
        String orig = "0010011000000011010010100000000110000111110011101010001010110000";
        String error = "0001010100000011010010100000000110000111100011001010001010110000";
        BinaryMessage errorMessage = BinaryMessage.load(error);
        BCH_63_16_11 bch = new BCH_63_16_11();
        mLog.debug("ORIG:" + orig);
        mLog.debug(" ERR:" + errorMessage.toString());
        mLog.debug(" ");
        errorMessage = bch.correctNID(errorMessage);
        mLog.debug(" CRC: " + errorMessage.getCRC().name());
        mLog.debug("CORR:" + errorMessage.toString());
        mLog.debug("ORIG:" + orig);
    }
}

