/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.dsp.symbol;

import io.github.dsheirer.bits.IBinarySymbolProcessor;
import io.github.dsheirer.sample.Listener;
import io.github.dsheirer.sample.buffer.IByteBufferProvider;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinaryToByteBufferAssembler
implements IBinarySymbolProcessor,
IByteBufferProvider {
    private static final Logger mLog = LoggerFactory.getLogger(BinaryToByteBufferAssembler.class);
    private ByteBuffer mCurrentBuffer;
    private int mBufferSize;
    private byte mCurrentByte;
    private int mBitCount;
    private Listener<ByteBuffer> mBufferListener;

    public BinaryToByteBufferAssembler(int bufferSize) {
        this.mBufferSize = bufferSize;
        this.getNextBuffer();
    }

    private void getNextBuffer() {
        if (this.mCurrentBuffer != null && this.mBufferListener != null) {
            this.mCurrentBuffer.flip();
            this.mBufferListener.receive(this.mCurrentBuffer);
        }
        this.mCurrentBuffer = ByteBuffer.allocate(this.mBufferSize);
    }

    @Override
    public void process(boolean symbol) {
        this.mCurrentByte = (byte)(this.mCurrentByte << 1);
        if (symbol) {
            this.mCurrentByte = (byte)(this.mCurrentByte + 1);
        }
        ++this.mBitCount;
        if (this.mBitCount >= 8) {
            this.mCurrentBuffer.put(this.mCurrentByte);
            this.mCurrentByte = 0;
            this.mBitCount = 0;
            if (!this.mCurrentBuffer.hasRemaining()) {
                this.getNextBuffer();
            }
        }
    }

    @Override
    public void setBufferListener(Listener<ByteBuffer> listener) {
        this.mBufferListener = listener;
    }

    @Override
    public void removeBufferListener(Listener<ByteBuffer> listener) {
        this.mBufferListener = null;
    }

    @Override
    public boolean hasBufferListeners() {
        return this.mBufferListener != null;
    }
}

