/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.dsp.squelch;

import io.github.dsheirer.dsp.filter.iir.SinglePoleIirFilter;
import io.github.dsheirer.sample.Listener;
import io.github.dsheirer.source.SourceEvent;
import org.apache.commons.math3.util.FastMath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PowerSquelch
implements Listener<SourceEvent> {
    private static final Logger mLog = LoggerFactory.getLogger(PowerSquelch.class);
    private State mState = State.MUTE;
    private SinglePoleIirFilter mFilter;
    private float mPower = 0.0f;
    private float mSquelchThreshold;
    private int mRampThreshold;
    private int mRampCount;
    private boolean mSquelchChanged = false;
    private boolean mStateChange = false;
    private int mPowerLevelBroadcastCount = 0;
    private int mPowerLevelBroadcastThreshold;
    private Listener<SourceEvent> mSourceEventListener;

    public PowerSquelch(float alpha, float squelchThreshold, int ramp) {
        this.mFilter = new SinglePoleIirFilter(alpha);
        this.setSquelchThreshold(squelchThreshold);
        this.mRampThreshold = ramp;
        this.mPowerLevelBroadcastThreshold = 25000;
    }

    public void setSampleRate(int sampleRate) {
        this.mPowerLevelBroadcastThreshold = sampleRate / 2;
    }

    public float getSquelchThreshold() {
        return 10.0f * (float)FastMath.log10((double)this.mSquelchThreshold);
    }

    public void setSquelchThreshold(double squelchThreshold) {
        this.mSquelchThreshold = (float)FastMath.pow((double)10.0, (double)(squelchThreshold / 10.0));
        this.broadcast(SourceEvent.squelchThreshold(null, squelchThreshold));
    }

    public void process(float inphase, float quadrature) {
        this.process(inphase * inphase + quadrature * quadrature);
    }

    public void process(float magnitude) {
        this.mPower = this.mFilter.filter(magnitude);
        ++this.mPowerLevelBroadcastCount;
        if (this.mPowerLevelBroadcastCount % this.mPowerLevelBroadcastThreshold == 0) {
            this.mPowerLevelBroadcastCount = 0;
            this.broadcast(SourceEvent.channelPowerLevel(null, 10.0 * Math.log10(this.mPower)));
        }
        this.mStateChange = false;
        switch (this.mState) {
            case MUTE: {
                if (this.mute()) break;
                if (this.mRampThreshold > 0) {
                    this.mState = State.ATTACK;
                    ++this.mRampCount;
                    break;
                }
                this.mState = State.UNMUTE;
                this.mStateChange = true;
                break;
            }
            case ATTACK: {
                if (this.mRampCount >= this.mRampThreshold) {
                    this.mState = State.UNMUTE;
                    this.mStateChange = true;
                    break;
                }
                ++this.mRampCount;
                break;
            }
            case DECAY: {
                if (this.mRampCount <= 0) {
                    this.mState = State.MUTE;
                    this.mStateChange = true;
                    break;
                }
                --this.mRampCount;
                break;
            }
            case UNMUTE: {
                if (!this.mute()) break;
                if (this.mRampThreshold > 0) {
                    this.mState = State.DECAY;
                    --this.mRampCount;
                    break;
                }
                this.mState = State.MUTE;
                this.mStateChange = true;
            }
        }
        this.setSquelchChanged(this.mStateChange);
    }

    public boolean isMuted() {
        return this.mState == State.MUTE;
    }

    public boolean isUnmuted() {
        return this.mState == State.UNMUTE;
    }

    public boolean isFading() {
        return this.isAttack() || this.isDecay();
    }

    public boolean isAttack() {
        return this.mState == State.ATTACK;
    }

    public boolean isDecay() {
        return this.mState == State.DECAY;
    }

    public float getPower() {
        return (float)(10.0 * Math.log10(this.mPower));
    }

    private boolean mute() {
        return this.mPower < this.mSquelchThreshold;
    }

    public boolean isSquelchChanged() {
        return this.mSquelchChanged;
    }

    public void setSquelchChanged(boolean changed) {
        this.mSquelchChanged = changed;
    }

    public void setSourceEventListener(Listener<SourceEvent> listener) {
        this.mSourceEventListener = listener;
    }

    private void broadcast(SourceEvent event) {
        if (this.mSourceEventListener != null) {
            this.mSourceEventListener.receive(event);
        }
    }

    @Override
    public void receive(SourceEvent sourceEvent) {
        if (sourceEvent.getEvent() == SourceEvent.Event.REQUEST_CHANGE_SQUELCH_THRESHOLD) {
            this.setSquelchThreshold(sourceEvent.getValue().floatValue());
        } else if (sourceEvent.getEvent() == SourceEvent.Event.REQUEST_CURRENT_SQUELCH_THRESHOLD) {
            this.broadcast(SourceEvent.squelchThreshold(null, this.getSquelchThreshold()));
        }
    }

    private static enum State {
        ATTACK,
        DECAY,
        MUTE,
        UNMUTE;

    }
}

