/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.dsp.squelch;

import io.github.dsheirer.dsp.filter.iir.SinglePoleIirFilter;
import io.github.dsheirer.sample.Listener;
import io.github.dsheirer.source.SourceEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PowerMonitor {
    private static final Logger mLog = LoggerFactory.getLogger(PowerMonitor.class);
    private int mPowerLevelBroadcastCount = 0;
    private int mPowerLevelBroadcastThreshold = 25000;
    private Listener<SourceEvent> mSourceEventListener;
    private SinglePoleIirFilter mPowerFilter = new SinglePoleIirFilter(0.1f);

    public void setSampleRate(int sampleRate) {
        this.mPowerLevelBroadcastThreshold = sampleRate / 2;
    }

    public void process(float inphase, float quadrature) {
        ++this.mPowerLevelBroadcastCount;
        if (this.mPowerLevelBroadcastCount > this.mPowerLevelBroadcastThreshold) {
            this.mPowerFilter.filter(inphase * inphase + quadrature * quadrature);
        }
        if (this.mPowerLevelBroadcastCount > this.mPowerLevelBroadcastThreshold + 10) {
            this.mPowerLevelBroadcastCount = 0;
            this.broadcast(SourceEvent.channelPowerLevel(null, 10.0 * Math.log10(this.mPowerFilter.getValue())));
        }
    }

    public void process(float[] i, float[] q) {
        for (int x = 0; x < i.length; ++x) {
            this.process(i[x], q[x]);
        }
    }

    public void setSourceEventListener(Listener<SourceEvent> listener) {
        this.mSourceEventListener = listener;
    }

    private void broadcast(SourceEvent event) {
        if (this.mSourceEventListener != null) {
            this.mSourceEventListener.receive(event);
        }
    }
}

