/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.dsp.psk.pll;

import io.github.dsheirer.dsp.psk.pll.CostasLoop;
import io.github.dsheirer.dsp.psk.pll.IFrequencyErrorProcessor;
import io.github.dsheirer.dsp.psk.pll.PLLBandwidth;
import io.github.dsheirer.dsp.symbol.ISyncDetectListener;
import io.github.dsheirer.module.decode.FeedbackDecoder;
import io.github.dsheirer.source.SourceEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FrequencyCorrectionSyncMonitor
implements ISyncDetectListener,
IFrequencyErrorProcessor {
    private static final Logger mLog = LoggerFactory.getLogger(FrequencyCorrectionSyncMonitor.class);
    private static final int MAX_SYNC_COUNT = PLLBandwidth.BW_200.getRangeEnd();
    private FeedbackDecoder mFeedbackDecoder;
    private CostasLoop mCostasLoop;
    private int mSyncCount;

    public FrequencyCorrectionSyncMonitor(CostasLoop costasLoop, FeedbackDecoder feedbackDecoder) {
        this.mCostasLoop = costasLoop;
        this.mCostasLoop.setFrequencyErrorProcessor(this);
        this.mFeedbackDecoder = feedbackDecoder;
    }

    @Override
    public void syncDetected(int bitErrors) {
        ++this.mSyncCount;
        this.update();
    }

    @Override
    public void syncLost(int bitsProcessed) {
        this.mSyncCount -= 2;
        this.update();
    }

    private void update() {
        if (this.mSyncCount < 0) {
            this.mSyncCount = 0;
            return;
        }
        if (this.mSyncCount > MAX_SYNC_COUNT) {
            this.mSyncCount = MAX_SYNC_COUNT;
            return;
        }
    }

    public void reset() {
        this.mSyncCount = 0;
    }

    @Override
    public void processFrequencyError(long frequencyError) {
        this.mFeedbackDecoder.broadcast(SourceEvent.pllFrequencyMeasurement(frequencyError));
        if (this.mSyncCount > 2) {
            this.mFeedbackDecoder.broadcast(SourceEvent.frequencyErrorMeasurement(frequencyError));
        }
    }
}

