/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.dsp.psk;

import io.github.dsheirer.dsp.psk.InterpolatingSampleBuffer;
import io.github.dsheirer.dsp.psk.SymbolDecisionData;
import io.github.dsheirer.sample.complex.Complex;
import io.github.dsheirer.sample.complex.ComplexSampleListener;
import org.apache.commons.math3.util.FastMath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InterpolatingSampleBufferInstrumented
extends InterpolatingSampleBuffer {
    private static final Logger mLog = LoggerFactory.getLogger(InterpolatingSampleBufferInstrumented.class);
    private SymbolDecisionData mSymbolDecisionData;
    private ComplexSampleListener mSampleListener;
    private int mBufferLength;

    public InterpolatingSampleBufferInstrumented(float samplesPerSymbol, float symbolTimingGain) {
        super(samplesPerSymbol, symbolTimingGain);
        this.mBufferLength = (int)FastMath.ceil((double)samplesPerSymbol);
        this.mSymbolDecisionData = new SymbolDecisionData(this.mBufferLength);
    }

    @Override
    public void receive(Complex sample) {
        super.receive(sample);
        this.mSymbolDecisionData.receive(sample);
        if (this.mSampleListener != null) {
            this.mSampleListener.receive(sample.inphase(), sample.quadrature());
        }
    }

    public SymbolDecisionData getSymbolDecisionData() {
        for (int x = this.mDelayLinePointer; x < this.mDelayLinePointer + this.mBufferLength; ++x) {
            this.mSymbolDecisionData.receive(this.mDelayLineInphase[x], this.mDelayLineQuadrature[x]);
        }
        this.mSymbolDecisionData.setSamplingPoint(this.getSamplingPoint());
        return this.mSymbolDecisionData;
    }

    public void setSampleListener(ComplexSampleListener listener) {
        this.mSampleListener = listener;
    }
}

