/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.dsp.psk;

import io.github.dsheirer.dsp.filter.interpolator.RealInterpolator;
import io.github.dsheirer.sample.complex.Complex;
import org.apache.commons.math3.util.FastMath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InterpolatingSampleBuffer {
    private static final Logger mLog = LoggerFactory.getLogger(InterpolatingSampleBuffer.class);
    private static final float MAXIMUM_DEVIATION_SAMPLES_PER_SYMBOL = 0.02f;
    private Complex mPrecedingSample = new Complex(0.0f, 0.0f);
    private Complex mCurrentSample = new Complex(0.0f, 0.0f);
    private Complex mMiddleSample = new Complex(0.0f, 0.0f);
    protected float[] mDelayLineInphase;
    protected float[] mDelayLineQuadrature;
    protected int mDelayLinePointer = 0;
    private int mTwiceSamplesPerSymbol;
    private float mSamplingPoint;
    private float mSampleCounterGain = 0.5f;
    private float mDetectedSamplesPerSymbol;
    private float mDetectedSamplesPerSymbolGain = 0.1f * this.mSampleCounterGain * this.mSampleCounterGain;
    private float mMaximumSamplesPerSymbol;
    private float mMinimumSamplesPerSymbol;
    private RealInterpolator mInterpolator = new RealInterpolator(1.0f);

    public InterpolatingSampleBuffer(float samplesPerSymbol, float sampleCounterGain) {
        this.mSamplingPoint = samplesPerSymbol;
        this.mDetectedSamplesPerSymbol = samplesPerSymbol;
        this.mMaximumSamplesPerSymbol = samplesPerSymbol * 1.02f;
        this.mMinimumSamplesPerSymbol = samplesPerSymbol * 0.98f;
        this.mTwiceSamplesPerSymbol = (int)FastMath.floor((double)(2.0 * (double)samplesPerSymbol));
        this.mDelayLineInphase = new float[2 * this.mTwiceSamplesPerSymbol];
        this.mDelayLineQuadrature = new float[2 * this.mTwiceSamplesPerSymbol];
        this.mSampleCounterGain = sampleCounterGain;
        this.mDetectedSamplesPerSymbolGain = 0.1f * this.mSampleCounterGain * this.mSampleCounterGain;
    }

    public void receive(Complex sample) {
        this.mSamplingPoint -= 1.0f;
        this.mDelayLineInphase[this.mDelayLinePointer] = sample.inphase();
        this.mDelayLineInphase[this.mDelayLinePointer + this.mTwiceSamplesPerSymbol] = sample.inphase();
        this.mDelayLineQuadrature[this.mDelayLinePointer] = sample.quadrature();
        this.mDelayLineQuadrature[this.mDelayLinePointer + this.mTwiceSamplesPerSymbol] = sample.quadrature();
        ++this.mDelayLinePointer;
        this.mDelayLinePointer %= this.mTwiceSamplesPerSymbol;
    }

    public void increaseSampleCounter(float samplesToAdd) {
        this.mSamplingPoint += samplesToAdd;
    }

    public void resetAndAdjust(float symbolTimingError) {
        this.mDetectedSamplesPerSymbol += symbolTimingError * this.mDetectedSamplesPerSymbolGain;
        if (this.mDetectedSamplesPerSymbol > this.mMaximumSamplesPerSymbol) {
            this.mDetectedSamplesPerSymbol = this.mMaximumSamplesPerSymbol;
        }
        if (this.mDetectedSamplesPerSymbol < this.mMinimumSamplesPerSymbol) {
            this.mDetectedSamplesPerSymbol = this.mMinimumSamplesPerSymbol;
        }
        this.increaseSampleCounter(this.mDetectedSamplesPerSymbol + symbolTimingError * this.mSampleCounterGain);
    }

    public float getSamplingPoint() {
        return this.mSamplingPoint;
    }

    public boolean hasSymbol() {
        return this.mSamplingPoint < 1.0f;
    }

    public Complex getPrecedingSample() {
        this.mPrecedingSample.setValues(this.mDelayLineInphase[this.mDelayLinePointer + 3], this.mDelayLineQuadrature[this.mDelayLinePointer + 3]);
        return this.mPrecedingSample;
    }

    public Complex getCurrentSample() {
        this.mCurrentSample.setValues(this.getInphase(this.mSamplingPoint), this.getQuadrature(this.mSamplingPoint));
        return this.mCurrentSample;
    }

    public Complex getMiddleSample() {
        float halfDetectedSamplesPerSymbol = this.mDetectedSamplesPerSymbol / 2.0f;
        this.mMiddleSample.setValues(this.getInphase(halfDetectedSamplesPerSymbol), this.getQuadrature(halfDetectedSamplesPerSymbol));
        return this.mMiddleSample;
    }

    public float getInphase(float interpolation) {
        if (interpolation < 0.0f) {
            return this.mInterpolator.filter(this.mDelayLineInphase, this.mDelayLinePointer, 0.0f);
        }
        if (interpolation < 1.0f) {
            return this.mInterpolator.filter(this.mDelayLineInphase, this.mDelayLinePointer, interpolation);
        }
        int offset = (int)FastMath.floor((double)interpolation);
        return this.mInterpolator.filter(this.mDelayLineInphase, this.mDelayLinePointer + offset, interpolation - (float)offset);
    }

    public float getQuadrature(float interpolation) {
        if (interpolation < 0.0f) {
            return this.mInterpolator.filter(this.mDelayLineQuadrature, this.mDelayLinePointer, 0.0f);
        }
        if (interpolation < 1.0f) {
            return this.mInterpolator.filter(this.mDelayLineQuadrature, this.mDelayLinePointer, interpolation);
        }
        int offset = (int)FastMath.floor((double)interpolation);
        return this.mInterpolator.filter(this.mDelayLineQuadrature, this.mDelayLinePointer + offset, interpolation - (float)offset);
    }
}

