/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.dsp.psk;

import io.github.dsheirer.sample.complex.Complex;
import org.apache.commons.math3.util.FastMath;

public class GardnerDetector {
    private float mErrorInphase;
    private float mErrorQuadrature;
    private float mError;

    public float getError(Complex previous, Complex middle, Complex current) {
        this.mErrorInphase = (FastMath.abs((float)previous.inphase()) - FastMath.abs((float)current.inphase())) * FastMath.abs((float)middle.inphase());
        this.mErrorQuadrature = (FastMath.abs((float)previous.quadrature()) - FastMath.abs((float)current.quadrature())) * FastMath.abs((float)middle.quadrature());
        this.mError = GardnerDetector.normalize(this.mErrorInphase + this.mErrorQuadrature, 1.0f);
        return this.mError;
    }

    public static float normalize(float error, float maximum) {
        if (Float.isNaN(error)) {
            return 0.0f;
        }
        return GardnerDetector.clip(error, maximum);
    }

    public static float clip(float value, float maximum) {
        if (value > maximum) {
            return maximum;
        }
        if (value < -maximum) {
            return -maximum;
        }
        return value;
    }
}

