/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.dsp.psk;

import io.github.dsheirer.dsp.psk.DQPSKDecisionDirectedDemodulator;
import io.github.dsheirer.dsp.psk.InterpolatingSampleBufferInstrumented;
import io.github.dsheirer.dsp.psk.SymbolDecisionData;
import io.github.dsheirer.dsp.psk.pll.CostasLoop;
import io.github.dsheirer.dsp.psk.pll.IPhaseLockedLoop;
import io.github.dsheirer.sample.Listener;
import io.github.dsheirer.sample.complex.Complex;
import io.github.dsheirer.sample.complex.ComplexSamples;

public class DQPSKDecisionDirectedDemodulatorInstrumented
extends DQPSKDecisionDirectedDemodulator {
    private Listener<SymbolDecisionData> mSymbolDecisionDataListener;
    private Listener<Double> mSamplesPerSymbolListener;
    private Listener<Complex> mComplexSymbolListener;
    private Listener<Double> mPLLErrorListener;
    private Listener<Double> mPLLFrequencyListener;
    private Listener<ComplexSamples> mFilteredGainAppliedComplexBufferListener;
    private double mSampleRate;

    public DQPSKDecisionDirectedDemodulatorInstrumented(IPhaseLockedLoop phaseLockedLoop, InterpolatingSampleBufferInstrumented interpolatingSampleBuffer, double sampleRate) {
        super(phaseLockedLoop, interpolatingSampleBuffer);
        this.mSampleRate = sampleRate;
    }

    @Override
    public void receive(ComplexSamples complexSamples) {
        if (this.mFilteredGainAppliedComplexBufferListener != null) {
            this.mFilteredGainAppliedComplexBufferListener.receive(complexSamples);
        }
        super.receive(complexSamples);
    }

    @Override
    protected void calculateSymbol() {
        if (this.mSymbolDecisionDataListener != null) {
            this.mSymbolDecisionDataListener.receive(((InterpolatingSampleBufferInstrumented)this.getInterpolatingSampleBuffer()).getSymbolDecisionData());
        }
        super.calculateSymbol();
        if (this.mSamplesPerSymbolListener != null) {
            this.mSamplesPerSymbolListener.receive(Double.valueOf(this.getInterpolatingSampleBuffer().getSamplingPoint()));
        }
        if (this.mComplexSymbolListener != null) {
            this.mComplexSymbolListener.receive(this.mCurrentSymbol);
        }
        if (this.mPLLErrorListener != null) {
            this.mPLLErrorListener.receive(Double.valueOf(this.mSymbolEvaluator.getPhaseError()));
        }
        if (this.mPLLFrequencyListener != null) {
            double loopFrequency = ((CostasLoop)this.getPLL()).getLoopFrequency();
            this.mPLLFrequencyListener.receive(loopFrequency *= this.mSampleRate / (Math.PI * 2));
        }
    }

    public void setSymbolDecisionDataListener(Listener<SymbolDecisionData> listener) {
        this.mSymbolDecisionDataListener = listener;
    }

    public void setSamplesPerSymbolListener(Listener<Double> listener) {
        this.mSamplesPerSymbolListener = listener;
    }

    public void setComplexSymbolListener(Listener<Complex> listener) {
        this.mComplexSymbolListener = listener;
    }

    public void setPLLErrorListener(Listener<Double> listener) {
        this.mPLLErrorListener = listener;
    }

    public void setPLLFrequencyListener(Listener<Double> listener) {
        this.mPLLFrequencyListener = listener;
    }
}

