/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.dsp.mixer;

import io.github.dsheirer.dsp.mixer.ComplexMixer;
import io.github.dsheirer.sample.complex.ComplexSamples;
import io.github.dsheirer.vector.VectorUtilities;
import jdk.incubator.vector.FloatVector;
import jdk.incubator.vector.Vector;
import jdk.incubator.vector.VectorSpecies;

public class VectorComplexMixer
extends ComplexMixer {
    private static final VectorSpecies<Float> VECTOR_SPECIES = FloatVector.SPECIES_PREFERRED;

    public VectorComplexMixer(double frequency, double sampleRate) {
        super(frequency, sampleRate);
    }

    @Override
    public ComplexSamples mix(float[] iSamples, float[] qSamples, long timestamp) {
        VectorUtilities.checkComplexArrayLength(iSamples, qSamples, VECTOR_SPECIES);
        ComplexSamples mixer = this.generate(iSamples.length, timestamp);
        float[] iMixer = mixer.i();
        float[] qMixer = mixer.q();
        for (int x = 0; x < iSamples.length; x += VECTOR_SPECIES.length()) {
            FloatVector iS = FloatVector.fromArray(VECTOR_SPECIES, (float[])iSamples, (int)x);
            FloatVector qS = FloatVector.fromArray(VECTOR_SPECIES, (float[])qSamples, (int)x);
            FloatVector iM = FloatVector.fromArray(VECTOR_SPECIES, (float[])iMixer, (int)x);
            FloatVector qM = FloatVector.fromArray(VECTOR_SPECIES, (float[])qMixer, (int)x);
            iM.mul((Vector)iS).sub((Vector)qM.mul((Vector)qS)).intoArray(iMixer, x);
            qM.mul((Vector)iS).add((Vector)iM.mul((Vector)qS)).intoArray(qMixer, x);
        }
        return mixer;
    }
}

