/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.dsp.mixer;

import io.github.dsheirer.dsp.mixer.ComplexMixer;
import io.github.dsheirer.sample.complex.ComplexSamples;
import io.github.dsheirer.sample.complex.InterleavedComplexSamples;

public class ScalarComplexMixer
extends ComplexMixer {
    public ScalarComplexMixer(double frequency, double sampleRate, boolean disableSIMD) {
        super(frequency, sampleRate, disableSIMD);
    }

    public ScalarComplexMixer(double frequency, double sampleRate) {
        super(frequency, sampleRate);
    }

    @Override
    public ComplexSamples mix(float[] iSamples, float[] qSamples, long timestamp) {
        ComplexSamples mixer = this.generate(iSamples.length, timestamp);
        float[] iMixer = mixer.i();
        float[] qMixer = mixer.q();
        for (int x = 0; x < iSamples.length; ++x) {
            float inphase = iMixer[x] * iSamples[x] - qMixer[x] * qSamples[x];
            float quadrature = qMixer[x] * iSamples[x] + iMixer[x] * qSamples[x];
            iMixer[x] = inphase;
            qMixer[x] = quadrature;
        }
        return mixer;
    }

    @Override
    public ComplexSamples mix(InterleavedComplexSamples samples) {
        ComplexSamples mixer = this.generate(samples.samples().length / 2, samples.timestamp());
        float[] iMixer = mixer.i();
        float[] qMixer = mixer.q();
        int offset = 0;
        for (int x = 0; x < iMixer.length; ++x) {
            offset = 2 * x;
            float inphase = iMixer[x] * samples.samples()[offset] - qMixer[x] * samples.samples()[offset + 1];
            float quadrature = qMixer[x] * samples.samples()[offset] + iMixer[x] * samples.samples()[offset + 1];
            iMixer[x] = inphase;
            qMixer[x] = quadrature;
        }
        return mixer;
    }
}

