/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.dsp.magnitude;

import io.github.dsheirer.dsp.magnitude.IMagnitudeCalculator;
import io.github.dsheirer.vector.VectorUtilities;
import jdk.incubator.vector.FloatVector;
import jdk.incubator.vector.Vector;
import jdk.incubator.vector.VectorSpecies;

public class VectorMagnitudeCalculator256
implements IMagnitudeCalculator {
    private static final VectorSpecies<Float> VECTOR_SPECIES = FloatVector.SPECIES_256;

    @Override
    public float[] calculate(float[] i, float[] q) {
        VectorUtilities.checkComplexArrayLength(i, q, VECTOR_SPECIES);
        float[] magnitude = new float[i.length];
        for (int x = 0; x < i.length; x += VECTOR_SPECIES.length()) {
            FloatVector iVector = FloatVector.fromArray(VECTOR_SPECIES, (float[])i, (int)x);
            FloatVector qVector = FloatVector.fromArray(VECTOR_SPECIES, (float[])q, (int)x);
            FloatVector result = iVector.mul((Vector)iVector).add((Vector)qVector.mul((Vector)qVector));
            result.intoArray(magnitude, x);
        }
        return magnitude;
    }
}

