/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.dsp.gain.complex;

import io.github.dsheirer.dsp.gain.complex.ComplexGain;
import io.github.dsheirer.dsp.gain.complex.ComplexGainControl;
import io.github.dsheirer.dsp.gain.complex.IComplexGainControl;
import io.github.dsheirer.dsp.gain.complex.ScalarComplexGain;
import io.github.dsheirer.dsp.gain.complex.VectorComplexGain;
import io.github.dsheirer.dsp.gain.complex.VectorComplexGainControl;
import io.github.dsheirer.vector.calibrate.CalibrationManager;
import io.github.dsheirer.vector.calibrate.CalibrationType;
import io.github.dsheirer.vector.calibrate.Implementation;

public class ComplexGainFactory {
    public static IComplexGainControl getComplexGainControl() {
        Implementation implementation = CalibrationManager.getInstance().getImplementation(CalibrationType.GAIN_CONTROL_COMPLEX);
        switch (implementation) {
            case VECTOR_SIMD_PREFERRED: {
                return new VectorComplexGainControl();
            }
        }
        return new ComplexGainControl();
    }

    public static ComplexGain getComplexGain(float gain) {
        Implementation implementation = CalibrationManager.getInstance().getImplementation(CalibrationType.GAIN_CONTROL_COMPLEX);
        switch (implementation) {
            case VECTOR_SIMD_PREFERRED: {
                return new VectorComplexGain(gain);
            }
        }
        return new ScalarComplexGain(gain);
    }
}

