/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.dsp.gain.complex;

import io.github.dsheirer.dsp.gain.complex.IComplexGainControl;
import io.github.dsheirer.sample.complex.Complex;
import io.github.dsheirer.sample.complex.ComplexSamples;

public class ComplexGainControl
implements IComplexGainControl {
    public static final float OBJECTIVE_ENVELOPE = 1.0f;
    public static final float MINIMUM_ENVELOPE = 1.0E-4f;

    @Override
    public ComplexSamples process(float[] i, float[] q, long timestamp) {
        float maxEnvelope = 1.0E-4f;
        for (int x = 0; x < i.length; ++x) {
            maxEnvelope = Math.max(maxEnvelope, Complex.envelope(i[x], q[x]));
        }
        float gain = 1.0f / maxEnvelope;
        float[] iProcessed = new float[i.length];
        float[] qProcessed = new float[q.length];
        for (int x = 0; x < i.length; ++x) {
            iProcessed[x] = i[x] * gain;
            qProcessed[x] = q[x] * gain;
        }
        return new ComplexSamples(iProcessed, qProcessed, timestamp);
    }
}

