/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.dsp.filter.smoothing;

import io.github.dsheirer.dsp.filter.smoothing.SmoothingFilter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class RectangularSmoothingFilter
extends SmoothingFilter {
    private static Map<Integer, float[]> mMap = new HashMap<Integer, float[]>();

    public RectangularSmoothingFilter() {
        super(mMap, 3);
    }

    public static float[] getCoefficients(int points) {
        float[] coefficients = new float[points];
        Arrays.fill(coefficients, 1.0f / (float)points);
        return coefficients;
    }

    @Override
    public SmoothingFilter.SmoothingType getSmoothingType() {
        return SmoothingFilter.SmoothingType.RECTANGLE;
    }

    static {
        mMap.put(3, RectangularSmoothingFilter.getCoefficients(3));
        mMap.put(5, RectangularSmoothingFilter.getCoefficients(5));
        mMap.put(7, RectangularSmoothingFilter.getCoefficients(7));
        mMap.put(9, RectangularSmoothingFilter.getCoefficients(9));
        mMap.put(11, RectangularSmoothingFilter.getCoefficients(11));
        mMap.put(13, RectangularSmoothingFilter.getCoefficients(13));
        mMap.put(15, RectangularSmoothingFilter.getCoefficients(15));
        mMap.put(17, RectangularSmoothingFilter.getCoefficients(17));
        mMap.put(19, RectangularSmoothingFilter.getCoefficients(19));
        mMap.put(21, RectangularSmoothingFilter.getCoefficients(21));
        mMap.put(23, RectangularSmoothingFilter.getCoefficients(23));
        mMap.put(25, RectangularSmoothingFilter.getCoefficients(25));
        mMap.put(27, RectangularSmoothingFilter.getCoefficients(27));
        mMap.put(29, RectangularSmoothingFilter.getCoefficients(29));
        mMap.put(31, RectangularSmoothingFilter.getCoefficients(31));
    }
}

