/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.dsp.filter.interpolator;

import io.github.dsheirer.dsp.filter.interpolator.Interpolator;
import io.github.dsheirer.sample.complex.Complex;
import java.text.DecimalFormat;
import java.util.Arrays;
import org.apache.commons.lang3.Validate;
import org.apache.commons.math3.util.FastMath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RealInterpolator
extends Interpolator {
    private static final Logger mLog = LoggerFactory.getLogger(RealInterpolator.class);
    private float mGain;

    public RealInterpolator(float gain) {
        this.mGain = gain;
    }

    public float filter(float[] samples, int offset, float mu) {
        Validate.isTrue((samples.length >= offset + 7 ? 1 : 0) != 0);
        int index = (int)(128.0f * mu);
        float accumulator = TAPS[index][7] * samples[offset];
        accumulator += TAPS[index][6] * samples[offset + 1];
        accumulator += TAPS[index][5] * samples[offset + 2];
        accumulator += TAPS[index][4] * samples[offset + 3];
        accumulator += TAPS[index][3] * samples[offset + 4];
        accumulator += TAPS[index][2] * samples[offset + 5];
        accumulator += TAPS[index][1] * samples[offset + 6];
        return (accumulator += TAPS[index][0] * samples[offset + 7]) * this.mGain;
    }

    public Complex filter(float[] iSamples, float[] qSamples, int offset, float mu) {
        float i = this.filter(iSamples, offset, mu);
        float q = this.filter(qSamples, offset, mu);
        return new Complex(i, q);
    }

    public static void main(String[] args) {
        RealInterpolator interpolator = new RealInterpolator(1.0f);
        DecimalFormat decimalFormat = new DecimalFormat("0.0000");
        double TWO_PI = Math.PI * 2;
        float[] samples = new float[16];
        for (int x = 0; x < 16; ++x) {
            samples[x] = (float)FastMath.sin((double)(TWO_PI * (double)x / 8.0));
        }
        mLog.debug("Samples: " + Arrays.toString(samples));
        for (float x = 0.0f; x <= 1.01f; x += 0.1f) {
            mLog.debug(decimalFormat.format(x) + ": " + decimalFormat.format(interpolator.filter(samples, 1, x)));
        }
    }
}

