/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.dsp.filter.fir.complex;

import io.github.dsheirer.dsp.filter.fir.complex.IComplexFilter;
import io.github.dsheirer.vector.VectorUtilities;
import jdk.incubator.vector.FloatVector;
import jdk.incubator.vector.Vector;
import jdk.incubator.vector.VectorMask;
import jdk.incubator.vector.VectorOperators;
import jdk.incubator.vector.VectorSpecies;
import org.apache.commons.lang3.ArrayUtils;

public class VectorComplexFIRFilter64Bit
implements IComplexFilter {
    private static final VectorSpecies<Float> VECTOR_SPECIES = FloatVector.SPECIES_64;
    private static final VectorMask<Float> I_VECTOR_MASK = VectorUtilities.getIVectorMask(VECTOR_SPECIES);
    private static final VectorMask<Float> Q_VECTOR_MASK = VectorUtilities.getQVectorMask(VECTOR_SPECIES);
    private float[] mBuffer;
    private float[] mCoefficients;
    private int mBufferOverlap;

    public VectorComplexFIRFilter64Bit(float[] coefficients) {
        int arrayLength;
        VectorUtilities.checkSpecies(VECTOR_SPECIES);
        for (arrayLength = VECTOR_SPECIES.length(); arrayLength < coefficients.length * 2; arrayLength += VECTOR_SPECIES.length()) {
        }
        this.mCoefficients = new float[arrayLength];
        ArrayUtils.reverse((float[])coefficients);
        for (int x = 0; x < coefficients.length; ++x) {
            this.mCoefficients[2 * x] = coefficients[x];
            this.mCoefficients[2 * x + 1] = coefficients[x];
        }
        this.mBufferOverlap = Math.max(arrayLength - 2, coefficients.length * 2 - 2);
        this.mBuffer = new float[this.mCoefficients.length];
    }

    @Override
    public float[] filter(float[] samples) {
        int bufferLength = samples.length + this.mBufferOverlap;
        if (this.mBuffer.length != bufferLength) {
            float[] temp = new float[bufferLength];
            System.arraycopy(this.mBuffer, this.mBuffer.length - this.mBufferOverlap, temp, 0, this.mBufferOverlap);
            this.mBuffer = temp;
        } else {
            System.arraycopy(this.mBuffer, samples.length, this.mBuffer, 0, this.mBufferOverlap);
        }
        System.arraycopy(samples, 0, this.mBuffer, this.mBufferOverlap, samples.length);
        float[] filtered = new float[samples.length];
        for (int bufferPointer = 0; bufferPointer < samples.length; bufferPointer += 2) {
            FloatVector accumulator = FloatVector.zero(VECTOR_SPECIES);
            for (int coefficientPointer = 0; coefficientPointer < this.mCoefficients.length; coefficientPointer += VECTOR_SPECIES.length()) {
                FloatVector filter = FloatVector.fromArray(VECTOR_SPECIES, (float[])this.mCoefficients, (int)coefficientPointer);
                FloatVector buffer = FloatVector.fromArray(VECTOR_SPECIES, (float[])this.mBuffer, (int)(bufferPointer + coefficientPointer));
                accumulator = filter.fma((Vector)buffer, (Vector)accumulator);
            }
            filtered[bufferPointer] = accumulator.reduceLanes(VectorOperators.ADD, I_VECTOR_MASK);
            filtered[bufferPointer + 1] = accumulator.reduceLanes(VectorOperators.ADD, Q_VECTOR_MASK);
        }
        return filtered;
    }
}

