/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.dsp.filter.dc;

import io.github.dsheirer.dsp.filter.dc.IDcRemovalFilter;
import io.github.dsheirer.dsp.filter.dc.VectorDcRemovalFilter;
import java.util.Random;

public class ScalarDcRemovalFilter
implements IDcRemovalFilter {
    private float mAverage;
    private float mGain;

    public ScalarDcRemovalFilter(float gain) {
        this.mGain = gain;
    }

    @Override
    public float[] filter(float[] samples) {
        float accumulator = 0.0f;
        float average = this.mAverage;
        for (float sample : samples) {
            accumulator += sample;
        }
        float averageDCNow = accumulator / (float)samples.length - average;
        average += this.mGain * averageDCNow;
        int x = 0;
        while (x < samples.length) {
            int n = x++;
            samples[n] = samples[n] - average;
        }
        this.mAverage = average;
        return samples;
    }

    public static void main(String[] args) {
        System.out.println("Starting ...");
        Random random = new Random();
        ScalarDcRemovalFilter scalarFilter = new ScalarDcRemovalFilter(0.15f);
        VectorDcRemovalFilter vectorFilter = new VectorDcRemovalFilter(0.15f);
        float dcOffset = 0.03f;
        float[] samples = new float[8192];
        for (int y = 0; y < samples.length; ++y) {
            samples[y] = random.nextFloat() * 2.0f - 1.0f + dcOffset;
        }
        long start = System.currentTimeMillis();
        for (int x = 0; x < 1000000; ++x) {
            vectorFilter.filter(samples);
        }
        long duration = System.currentTimeMillis() - start;
        System.out.println("Finished - Duration: " + duration);
    }
}

