/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.dsp.filter.dc;

public class IIRSinglePoleDCRemovalFilter {
    private float mAlpha;
    private float mPreviousInput = 0.0f;
    private float mPreviousOutput = 0.0f;
    private float mCurrentOutput = 0.0f;

    public IIRSinglePoleDCRemovalFilter(float alpha) {
        this.mAlpha = alpha;
    }

    public float filter(float sample) {
        this.mCurrentOutput = sample - this.mPreviousInput + this.mAlpha * this.mPreviousOutput;
        this.mPreviousInput = sample;
        this.mPreviousOutput = this.mCurrentOutput;
        return this.mCurrentOutput;
    }

    public float[] filter(float[] samples) {
        for (int x = 0; x < samples.length; ++x) {
            samples[x] = this.filter(samples[x]);
        }
        return samples;
    }
}

