/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.dsp.filter.channelizer.output;

import io.github.dsheirer.sample.complex.ComplexSamples;

public class SampleAssembler {
    private final int mBufferSize;
    private float[] mI;
    private float[] mQ;
    private int mPointer = 0;

    public SampleAssembler(int bufferSize) {
        this.mBufferSize = bufferSize;
        this.reset();
    }

    private void reset() {
        this.mPointer = 0;
        this.mI = new float[this.mBufferSize];
        this.mQ = new float[this.mBufferSize];
    }

    public void receive(float i, float q) {
        if (this.mPointer >= this.mBufferSize) {
            throw new IllegalStateException("Buffer is full.  Use flushBuffer() to reset the assembler.");
        }
        this.mI[this.mPointer] = i;
        this.mQ[this.mPointer++] = q;
    }

    public boolean hasBuffer() {
        return this.mPointer >= this.mBufferSize;
    }

    public ComplexSamples getBufferAndReset(long timestamp) {
        ComplexSamples buffer = new ComplexSamples(this.mI, this.mQ, timestamp);
        this.reset();
        return buffer;
    }
}

