/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.dsp.filter;

import io.github.dsheirer.sample.Listener;
import java.util.BitSet;

public class LTRPulseShapingFilter
implements Listener<Boolean> {
    private int[][] mIndexes = new int[][]{{0, 1, 2, 3, 4}, {1, 2, 3, 4, 0}, {2, 3, 4, 0, 1}, {3, 4, 0, 1, 2}, {4, 0, 1, 2, 3}};
    private BitSet mBuffer = new BitSet();
    private int mBufferPointer = 0;
    private Listener<Boolean> mListener;

    public LTRPulseShapingFilter() {
        this.mBuffer.clear();
    }

    @Override
    public void receive(Boolean current) {
        boolean previous = this.mBuffer.get(this.mBufferPointer);
        if (current.booleanValue()) {
            this.mBuffer.set(this.mBufferPointer);
        } else {
            this.mBuffer.clear(this.mBufferPointer);
        }
        ++this.mBufferPointer;
        if (this.mBufferPointer >= 5) {
            this.mBufferPointer = 0;
        }
        if (this.mBuffer.cardinality() == 2) {
            if (this.mBuffer.get(this.mIndexes[this.mBufferPointer][1]) && this.mBuffer.get(this.mIndexes[this.mBufferPointer][2])) {
                this.mBuffer.set(this.mIndexes[this.mBufferPointer][3]);
            }
        } else if (this.mBuffer.cardinality() == 3 && !this.mBuffer.get(this.mIndexes[this.mBufferPointer][1]) && !this.mBuffer.get(this.mIndexes[this.mBufferPointer][2])) {
            this.mBuffer.clear(this.mIndexes[this.mBufferPointer][3]);
        }
        if (this.mListener != null) {
            this.mListener.receive(previous);
        }
    }

    public String getIndexSet(int pointer) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int x = 0; x < 5; ++x) {
            sb.append(this.mIndexes[pointer][x]);
            sb.append(",");
        }
        sb.append("[");
        return sb.toString();
    }

    public void setListener(Listener<Boolean> listener) {
        this.mListener = listener;
    }

    public void removeListener(Listener<Boolean> listener) {
        this.mListener = null;
    }
}

