/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.dsp.am;

import io.github.dsheirer.dsp.am.IAmDemodulator;
import io.github.dsheirer.dsp.am.ScalarAMDemodulator;
import io.github.dsheirer.dsp.am.VectorAMDemodulator128;
import io.github.dsheirer.dsp.am.VectorAMDemodulator256;
import io.github.dsheirer.dsp.am.VectorAMDemodulator512;
import io.github.dsheirer.dsp.am.VectorAMDemodulator64;
import io.github.dsheirer.dsp.magnitude.IMagnitudeCalculator;
import io.github.dsheirer.dsp.magnitude.MagnitudeFactory;
import io.github.dsheirer.vector.calibrate.Calibration;
import io.github.dsheirer.vector.calibrate.CalibrationException;
import io.github.dsheirer.vector.calibrate.CalibrationType;
import io.github.dsheirer.vector.calibrate.Implementation;
import org.apache.commons.math3.stat.descriptive.moment.Mean;

public class AmDemodulatorCalibration
extends Calibration {
    private static final int BUFFER_SIZE = 2048;
    private static final int ITERATION_DURATION_MS = 1000;
    private static final int WARMUP_ITERATIONS = 5;
    private static final int TEST_ITERATIONS = 5;
    private IMagnitudeCalculator mMagnitudeCalculator = MagnitudeFactory.getMagnitudeCalculator();
    private IAmDemodulator mScalarDemodulator = new ScalarAMDemodulator(500.0f);
    private IAmDemodulator mVectorDemodulator64 = new VectorAMDemodulator64(500.0f);
    private IAmDemodulator mVectorDemodulator128 = new VectorAMDemodulator128(500.0f);
    private IAmDemodulator mVectorAMDemodulator256 = new VectorAMDemodulator256(500.0f);
    private IAmDemodulator mVectorAMDemodulator512 = new VectorAMDemodulator512(500.0f);

    public AmDemodulatorCalibration() {
        super(CalibrationType.AM_DEMODULATOR);
    }

    @Override
    public void calibrate() throws CalibrationException {
        long score;
        int x;
        float[] magnitude = this.getFloatSamples(2048);
        Mean scalarMean = new Mean();
        for (int x2 = 0; x2 < 5; ++x2) {
            long score2 = this.testScalar(magnitude);
            scalarMean.increment((double)score2);
        }
        mLog.info("AM DEMODULATOR WARMUP - SCALAR: " + DECIMAL_FORMAT.format(scalarMean.getResult()));
        Mean vector64Mean = new Mean();
        for (int x3 = 0; x3 < 5; ++x3) {
            long score3 = this.testVector64(magnitude);
            vector64Mean.increment((double)score3);
        }
        mLog.info("AM DEMODULATOR WARMUP - VECTOR 64: " + DECIMAL_FORMAT.format(vector64Mean.getResult()));
        Mean vector128Mean = new Mean();
        for (int x4 = 0; x4 < 5; ++x4) {
            long score4 = this.testVector128(magnitude);
            vector128Mean.increment((double)score4);
        }
        mLog.info("AM DEMODULATOR WARMUP - VECTOR 128: " + DECIMAL_FORMAT.format(vector128Mean.getResult()));
        Mean vector256Mean = new Mean();
        for (int x5 = 0; x5 < 5; ++x5) {
            long score5 = this.testVector256(magnitude);
            vector256Mean.increment((double)score5);
        }
        mLog.info("AM DEMODULATOR WARMUP - VECTOR 256: " + DECIMAL_FORMAT.format(vector256Mean.getResult()));
        Mean vector512Mean = new Mean();
        for (x = 0; x < 5; ++x) {
            score = this.testVector512(magnitude);
            vector512Mean.increment((double)score);
        }
        mLog.info("AM DEMODULATOR WARMUP - VECTOR 512: " + DECIMAL_FORMAT.format(vector512Mean.getResult()));
        scalarMean.clear();
        for (x = 0; x < 5; ++x) {
            score = this.testScalar(magnitude);
            scalarMean.increment((double)score);
        }
        mLog.info("AM DEMODULATOR - SCALAR: " + DECIMAL_FORMAT.format(scalarMean.getResult()));
        vector64Mean.clear();
        for (x = 0; x < 5; ++x) {
            score = this.testVector64(magnitude);
            vector64Mean.increment((double)score);
        }
        mLog.info("AM DEMODULATOR - VECTOR 64: " + DECIMAL_FORMAT.format(vector64Mean.getResult()));
        vector128Mean.clear();
        for (x = 0; x < 5; ++x) {
            score = this.testVector128(magnitude);
            vector128Mean.increment((double)score);
        }
        mLog.info("AM DEMODULATOR - VECTOR 128: " + DECIMAL_FORMAT.format(vector128Mean.getResult()));
        vector256Mean.clear();
        for (x = 0; x < 5; ++x) {
            score = this.testVector256(magnitude);
            vector256Mean.increment((double)score);
        }
        mLog.info("AM DEMODULATOR - VECTOR 256: " + DECIMAL_FORMAT.format(vector256Mean.getResult()));
        vector512Mean.clear();
        for (x = 0; x < 5; ++x) {
            score = this.testVector512(magnitude);
            vector512Mean.increment((double)score);
        }
        mLog.info("AM DEMODULATOR - VECTOR 512: " + DECIMAL_FORMAT.format(vector512Mean.getResult()));
        Implementation optimal = Implementation.SCALAR;
        double optimalResult = scalarMean.getResult();
        if (vector64Mean.getResult() > optimalResult) {
            optimal = Implementation.VECTOR_SIMD_64;
            optimalResult = vector64Mean.getResult();
        }
        if (vector128Mean.getResult() > optimalResult) {
            optimal = Implementation.VECTOR_SIMD_128;
            optimalResult = vector128Mean.getResult();
        }
        if (vector256Mean.getResult() > optimalResult) {
            optimal = Implementation.VECTOR_SIMD_256;
            optimalResult = vector256Mean.getResult();
        }
        if (vector512Mean.getResult() > optimalResult) {
            optimal = Implementation.VECTOR_SIMD_512;
        }
        this.setImplementation(optimal);
        mLog.info("AM DEMODULATOR - SET OPTIMAL IMPLEMENTATION TO:" + String.valueOf((Object)this.getImplementation()));
    }

    private long testScalar(float[] magnitude) {
        double accumulator = 0.0;
        long count = 0L;
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < 1000L) {
            float[] demodulated = this.mScalarDemodulator.demodulateMagnitude(magnitude);
            accumulator += (double)demodulated[1];
            ++count;
        }
        return count + (long)(accumulator * 0.0);
    }

    private long testVector64(float[] magnitude) {
        double accumulator = 0.0;
        long count = 0L;
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < 1000L) {
            float[] demodulated = this.mVectorDemodulator64.demodulateMagnitude(magnitude);
            accumulator += (double)demodulated[1];
            ++count;
        }
        return count + (long)(accumulator * 0.0);
    }

    private long testVector128(float[] magnitude) {
        double accumulator = 0.0;
        long count = 0L;
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < 1000L) {
            float[] demodulated = this.mVectorDemodulator128.demodulateMagnitude(magnitude);
            accumulator += (double)demodulated[1];
            ++count;
        }
        return count + (long)(accumulator * 0.0);
    }

    private long testVector256(float[] magnitude) {
        double accumulator = 0.0;
        long count = 0L;
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < 1000L) {
            float[] demodulated = this.mVectorAMDemodulator256.demodulateMagnitude(magnitude);
            accumulator += (double)demodulated[1];
            ++count;
        }
        return count + (long)(accumulator * 0.0);
    }

    private long testVector512(float[] magnitude) {
        double accumulator = 0.0;
        long count = 0L;
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < 1000L) {
            float[] demodulated = this.mVectorAMDemodulator512.demodulateMagnitude(magnitude);
            accumulator += (double)demodulated[1];
            ++count;
        }
        return count + (long)(accumulator * 0.0);
    }

    public static void main(String[] args) {
        AmDemodulatorCalibration calibration = new AmDemodulatorCalibration();
        try {
            calibration.calibrate();
        }
        catch (Exception e) {
            mLog.error("Error during calibration", (Throwable)e);
        }
    }
}

