/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.controller.channel.map;

import io.github.dsheirer.controller.channel.map.ChannelMap;
import io.github.dsheirer.controller.channel.map.ChannelMapEvent;
import io.github.dsheirer.sample.Broadcaster;
import io.github.dsheirer.sample.Listener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javax.swing.AbstractListModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelMapModel
extends AbstractListModel<ChannelMap> {
    private static final long serialVersionUID = 1L;
    private static final Logger mLog = LoggerFactory.getLogger(ChannelMapModel.class);
    private ObservableList<ChannelMap> mChannelMaps = FXCollections.observableArrayList(ChannelMap.extractor());
    private Broadcaster<ChannelMapEvent> mEventBroadcaster = new Broadcaster();

    public void clear() {
        ArrayList<ChannelMap> channelMaps = new ArrayList<ChannelMap>((Collection<ChannelMap>)this.mChannelMaps);
        for (ChannelMap channelMap : channelMaps) {
            this.removeChannelMap(channelMap);
        }
    }

    public ObservableList<ChannelMap> getChannelMaps() {
        return this.mChannelMaps;
    }

    public ChannelMap getChannelMap(String name) {
        for (ChannelMap channelMap : this.mChannelMaps) {
            if (!channelMap.getName().equalsIgnoreCase(name)) continue;
            return channelMap;
        }
        return null;
    }

    public void addListener(Listener<ChannelMapEvent> listener) {
        this.mEventBroadcaster.addListener(listener);
    }

    public void removeListener(Listener<ChannelMapEvent> listener) {
        this.mEventBroadcaster.removeListener(listener);
    }

    public void broadcast(ChannelMapEvent event) {
        int index;
        if ((event.getEvent() == ChannelMapEvent.Event.CHANGE || event.getEvent() == ChannelMapEvent.Event.RENAME) && (index = this.mChannelMaps.indexOf((Object)event.getChannelMap())) >= 0) {
            this.fireContentsChanged(this, index, index);
        }
        this.mEventBroadcaster.broadcast(event);
    }

    public void addChannelMaps(List<ChannelMap> channelMaps) {
        for (ChannelMap channelMap : channelMaps) {
            this.addChannelMap(channelMap);
        }
    }

    public void addChannelMap(ChannelMap channelMap) {
        if (!this.mChannelMaps.contains((Object)channelMap)) {
            this.mChannelMaps.add((Object)channelMap);
            int index = this.mChannelMaps.indexOf((Object)channelMap);
            this.fireIntervalAdded(this, index, index);
            this.broadcast(new ChannelMapEvent(channelMap, ChannelMapEvent.Event.ADD));
        }
    }

    public void removeChannelMap(ChannelMap channelMap) {
        if (this.mChannelMaps.contains((Object)channelMap)) {
            int index = this.mChannelMaps.indexOf((Object)channelMap);
            this.mChannelMaps.remove((Object)channelMap);
            this.fireIntervalRemoved(this, index, index);
            this.broadcast(new ChannelMapEvent(channelMap, ChannelMapEvent.Event.DELETE));
        }
    }

    @Override
    public int getSize() {
        return this.mChannelMaps.size();
    }

    @Override
    public ChannelMap getElementAt(int index) {
        if (index <= this.mChannelMaps.size()) {
            return (ChannelMap)this.mChannelMaps.get(index);
        }
        return null;
    }
}

