/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.controller.channel.map;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import io.github.dsheirer.controller.channel.map.ChannelRange;
import java.util.List;
import javafx.beans.Observable;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.util.Callback;

public class ChannelMap {
    private StringProperty mName = new SimpleStringProperty();
    private BooleanProperty mValidProperty = new SimpleBooleanProperty();
    private ObservableList<ChannelRange> mRanges = FXCollections.observableArrayList(ChannelRange.extractor());

    public ChannelMap() {
        this("New Channel Map");
    }

    public ChannelMap(String name) {
        this.mName.set((Object)name);
        this.mRanges.addListener(c -> this.validate());
    }

    public StringProperty nameProperty() {
        return this.mName;
    }

    public BooleanProperty validProperty() {
        return this.mValidProperty;
    }

    @JsonIgnore
    public ObservableList<ChannelRange> getItems() {
        return this.mRanges;
    }

    public ChannelMap copyOf() {
        ChannelMap map = new ChannelMap(new String((String)this.mName.get()));
        for (ChannelRange range : this.mRanges) {
            map.addRange(range.copyOf());
        }
        return map;
    }

    @JsonIgnore
    public boolean isValid() {
        return this.mValidProperty.get();
    }

    public String toString() {
        return (String)this.mName.get();
    }

    @JacksonXmlProperty(isAttribute=false, localName="range")
    public List<ChannelRange> getRanges() {
        return this.mRanges;
    }

    public void setRanges(List<ChannelRange> ranges) {
        this.mRanges.setAll(ranges);
    }

    @JacksonXmlProperty(isAttribute=true, localName="name")
    public String getName() {
        return (String)this.mName.get();
    }

    public void setName(String name) {
        this.mName.set((Object)name);
    }

    public long getFrequency(int channelNumber) {
        for (ChannelRange range : this.mRanges) {
            if (!range.hasChannel(channelNumber)) continue;
            return range.getFrequency(channelNumber);
        }
        return 0L;
    }

    private void validate() {
        this.mValidProperty.set(true);
        for (ChannelRange channelRange : this.mRanges) {
            channelRange.setOverlapping(false);
        }
        for (int x = 0; x < this.mRanges.size(); ++x) {
            if (!((ChannelRange)this.mRanges.get(x)).isValid()) {
                this.mValidProperty.set(false);
            }
            for (int y = x + 1; y < this.mRanges.size(); ++y) {
                if (!((ChannelRange)this.mRanges.get(x)).overlaps((ChannelRange)this.mRanges.get(y))) continue;
                ((ChannelRange)this.mRanges.get(x)).setOverlapping(true);
                ((ChannelRange)this.mRanges.get(y)).setOverlapping(true);
                this.mValidProperty.set(false);
            }
        }
    }

    public void addRange(ChannelRange range) {
        this.mRanges.add((Object)range);
    }

    public void removeRange(ChannelRange range) {
        this.mRanges.remove((Object)range);
    }

    /*
     * Exception decompiling
     */
    public static Callback<ChannelMap, Observable[]> extractor() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

