/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.controller.channel;

import io.github.dsheirer.controller.channel.Channel;

public class ChannelEvent {
    private Channel mChannel;
    private Event mEvent;
    private String mDescription;

    public ChannelEvent(Channel channel, Event event, String description) {
        this.mChannel = channel;
        this.mEvent = event;
        this.mDescription = description;
    }

    public ChannelEvent(Channel channel, Event event) {
        this(channel, event, null);
    }

    public Channel getChannel() {
        return this.mChannel;
    }

    public Event getEvent() {
        return this.mEvent;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public String toString() {
        return this.getEvent().name() + " Channel:" + this.getChannel().getName() + (String)(this.mDescription != null ? " Description:" + this.mDescription : "");
    }

    public static ChannelEvent requestEnable(Channel channel) {
        return new ChannelEvent(channel, Event.REQUEST_ENABLE);
    }

    public static ChannelEvent requestDisable(Channel channel) {
        return new ChannelEvent(channel, Event.REQUEST_DISABLE);
    }

    public static enum Event {
        NOTIFICATION_ADD,
        NOTIFICATION_CONFIGURATION_CHANGE,
        NOTIFICATION_DELETE,
        NOTIFICATION_PROCESSING_START_REJECTED,
        NOTIFICATION_PROCESSING_START,
        NOTIFICATION_PROCESSING_STOP,
        NOTIFICATION_SELECTION_CHANGE,
        NOTIFICATION_STATE_RESET,
        REQUEST_DELETE,
        REQUEST_DESELECT,
        REQUEST_DISABLE,
        REQUEST_ENABLE,
        REQUEST_SELECT;

    }
}

