/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.controller;

import io.github.dsheirer.util.ThreadPool;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamingThreadFactory
implements ThreadFactory {
    private static final Logger mLog = LoggerFactory.getLogger(ThreadPool.class);
    private static final AtomicInteger mPoolNumber = new AtomicInteger(1);
    private final ThreadGroup mThreadGroup;
    private final AtomicInteger mThreadNumber = new AtomicInteger(1);
    private final String mNamePrefix;

    public NamingThreadFactory(String prefix) {
        this.mThreadGroup = Thread.currentThread().getThreadGroup();
        this.mNamePrefix = prefix + " thread ";
    }

    @Override
    public Thread newThread(Runnable runnable) {
        Thread thread = new Thread(this.mThreadGroup, runnable, this.mNamePrefix + this.mThreadNumber.getAndIncrement(), 0L);
        if (thread.isDaemon()) {
            thread.setDaemon(false);
        }
        if (thread.getPriority() != 5) {
            thread.setPriority(5);
        }
        thread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(this){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                mLog.error("Error while executing runnable in scheduled thread pool [" + t.getName() + "]", e);
            }
        });
        return thread;
    }
}

