/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.channel.state;

import io.github.dsheirer.channel.state.DecoderState;
import io.github.dsheirer.channel.state.DecoderStateEvent;
import io.github.dsheirer.channel.state.State;
import io.github.dsheirer.identifier.Form;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.identifier.IdentifierClass;
import io.github.dsheirer.identifier.Role;
import io.github.dsheirer.identifier.string.SimpleStringIdentifier;
import io.github.dsheirer.message.IMessage;
import io.github.dsheirer.module.decode.DecoderType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlwaysUnsquelchedDecoderState
extends DecoderState {
    private static final Logger mLog = LoggerFactory.getLogger(AlwaysUnsquelchedDecoderState.class);
    private static final String NO_SQUELCH = "No Squelch";
    private Identifier mChannelNameIdentifier;
    private DecoderType mDecoderType;
    private String mChannelName;

    public AlwaysUnsquelchedDecoderState(DecoderType decoderType, String channelName) {
        this.mDecoderType = decoderType;
        this.mChannelName = channelName != null && !channelName.isEmpty() ? channelName : decoderType.name() + " CHANNEL";
        this.mChannelNameIdentifier = new SimpleStringIdentifier(this.mChannelName, IdentifierClass.USER, Form.CHANNEL_NAME, Role.TO);
    }

    @Override
    public void init() {
    }

    @Override
    public String getActivitySummary() {
        StringBuilder sb = new StringBuilder();
        sb.append("Activity Summary\n");
        sb.append("\tDecoder:\t");
        sb.append((Object)this.mDecoderType);
        sb.append("\n\n");
        return sb.toString();
    }

    @Override
    public void receive(IMessage t) {
    }

    @Override
    public void receiveDecoderStateEvent(DecoderStateEvent event) {
        if (event.getEvent() == DecoderStateEvent.Event.REQUEST_RESET) {
            this.getIdentifierCollection().update(this.mChannelNameIdentifier);
        }
    }

    @Override
    public DecoderType getDecoderType() {
        return this.mDecoderType;
    }

    @Override
    public void start() {
        this.broadcast(new DecoderStateEvent(this, DecoderStateEvent.Event.REQUEST_ALWAYS_UNSQUELCH, State.IDLE));
        this.getIdentifierCollection().update(this.mChannelNameIdentifier);
    }

    @Override
    public void stop() {
    }
}

