/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.channel.state;

import io.github.dsheirer.channel.state.DecoderStateEvent;
import io.github.dsheirer.channel.state.IDecoderStateEventListener;
import io.github.dsheirer.channel.state.IDecoderStateEventProvider;
import io.github.dsheirer.identifier.IdentifierUpdateListener;
import io.github.dsheirer.identifier.IdentifierUpdateProvider;
import io.github.dsheirer.message.IMessage;
import io.github.dsheirer.message.IMessageListener;
import io.github.dsheirer.module.Module;
import io.github.dsheirer.module.decode.DecoderType;
import io.github.dsheirer.module.decode.event.ActivitySummaryProvider;
import io.github.dsheirer.module.decode.event.IDecodeEvent;
import io.github.dsheirer.module.decode.event.IDecodeEventProvider;
import io.github.dsheirer.sample.Broadcaster;
import io.github.dsheirer.sample.Listener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDecoderState
extends Module
implements ActivitySummaryProvider,
Listener<IMessage>,
IDecodeEventProvider,
IDecoderStateEventListener,
IDecoderStateEventProvider,
IMessageListener,
IdentifierUpdateProvider,
IdentifierUpdateListener {
    private static final Logger mLog = LoggerFactory.getLogger(AbstractDecoderState.class);
    protected String DIVIDER1 = "======================================================\n";
    protected String DIVIDER2 = "------------------------------------------------------\n";
    protected Broadcaster<IDecodeEvent> mDecodeEventBroadcaster = new Broadcaster();
    protected Listener<DecoderStateEvent> mDecoderStateListener;
    private DecoderStateEventListener mDecoderStateEventListener = new DecoderStateEventListener();

    public abstract DecoderType getDecoderType();

    protected Broadcaster<IDecodeEvent> getDecodeEventBroadcaster() {
        return this.mDecodeEventBroadcaster;
    }

    @Override
    public Listener<IMessage> getMessageListener() {
        return this;
    }

    public abstract void receiveDecoderStateEvent(DecoderStateEvent var1);

    @Override
    public abstract String getActivitySummary();

    protected void broadcast(IDecodeEvent event) {
        this.mDecodeEventBroadcaster.broadcast(event);
    }

    @Override
    public void addDecodeEventListener(Listener<IDecodeEvent> listener) {
        this.mDecodeEventBroadcaster.addListener(listener);
    }

    @Override
    public void removeDecodeEventListener(Listener<IDecodeEvent> listener) {
        this.mDecodeEventBroadcaster.removeListener(listener);
    }

    @Override
    public Listener<DecoderStateEvent> getDecoderStateListener() {
        return this.mDecoderStateEventListener;
    }

    protected void broadcast(DecoderStateEvent event) {
        if (this.mDecoderStateListener != null) {
            this.mDecoderStateListener.receive(event);
        }
    }

    @Override
    public void setDecoderStateListener(Listener<DecoderStateEvent> listener) {
        this.mDecoderStateListener = listener;
    }

    @Override
    public void removeDecoderStateListener() {
        this.mDecoderStateListener = null;
    }

    private class DecoderStateEventListener
    implements Listener<DecoderStateEvent> {
        private DecoderStateEventListener() {
        }

        @Override
        public void receive(DecoderStateEvent event) {
            AbstractDecoderState.this.receiveDecoderStateEvent(event);
        }
    }
}

