/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.channel.state;

import io.github.dsheirer.audio.squelch.ISquelchStateProvider;
import io.github.dsheirer.channel.metadata.ChannelMetadata;
import io.github.dsheirer.channel.state.DecoderStateEvent;
import io.github.dsheirer.channel.state.IDecoderStateEventProvider;
import io.github.dsheirer.controller.channel.Channel;
import io.github.dsheirer.controller.channel.ChannelEvent;
import io.github.dsheirer.controller.channel.IChannelEventProvider;
import io.github.dsheirer.identifier.IdentifierUpdateNotification;
import io.github.dsheirer.identifier.IdentifierUpdateProvider;
import io.github.dsheirer.module.Module;
import io.github.dsheirer.module.decode.event.IDecodeEvent;
import io.github.dsheirer.module.decode.event.IDecodeEventProvider;
import io.github.dsheirer.sample.IOverflowListener;
import io.github.dsheirer.sample.Listener;
import io.github.dsheirer.source.ISourceEventProvider;
import io.github.dsheirer.source.SourceEvent;
import io.github.dsheirer.source.heartbeat.Heartbeat;
import io.github.dsheirer.source.heartbeat.IHeartbeatListener;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractChannelState
extends Module
implements IChannelEventProvider,
IDecodeEventProvider,
IDecoderStateEventProvider,
ISourceEventProvider,
IHeartbeatListener,
ISquelchStateProvider,
IdentifierUpdateProvider,
IOverflowListener {
    private static final Logger mLog = LoggerFactory.getLogger(AbstractChannelState.class);
    protected Listener<ChannelEvent> mChannelEventListener;
    protected Listener<IDecodeEvent> mDecodeEventListener;
    protected Listener<DecoderStateEvent> mDecoderStateListener;
    protected Listener<SourceEvent> mExternalSourceEventListener;
    private Channel mChannel;
    protected boolean mSourceOverflow = false;
    private HeartbeatReceiver mHeartbeatReceiver = new HeartbeatReceiver();

    public AbstractChannelState(Channel channel) {
        this.mChannel = channel;
    }

    protected void updateChannelConfiguration(Channel channel) {
        this.mChannel = channel;
    }

    protected Channel getChannel() {
        return this.mChannel;
    }

    protected abstract void checkState();

    public abstract List<ChannelMetadata> getChannelMetadata();

    public abstract void updateChannelStateIdentifiers(IdentifierUpdateNotification var1);

    @Override
    public Listener<Heartbeat> getHeartbeatListener() {
        return this.mHeartbeatReceiver;
    }

    @Override
    public void sourceOverflow(boolean overflow) {
        this.mSourceOverflow = overflow;
    }

    public boolean isOverflow() {
        return this.mSourceOverflow;
    }

    @Override
    public void setChannelEventListener(Listener<ChannelEvent> listener) {
        this.mChannelEventListener = listener;
    }

    @Override
    public void removeChannelEventListener() {
        this.mChannelEventListener = null;
    }

    @Override
    public void addDecodeEventListener(Listener<IDecodeEvent> listener) {
        this.mDecodeEventListener = listener;
    }

    @Override
    public void removeDecodeEventListener(Listener<IDecodeEvent> listener) {
        this.mDecodeEventListener = null;
    }

    @Override
    public void setDecoderStateListener(Listener<DecoderStateEvent> listener) {
        this.mDecoderStateListener = listener;
    }

    @Override
    public void removeDecoderStateListener() {
        this.mDecoderStateListener = null;
    }

    @Override
    public void setSourceEventListener(Listener<SourceEvent> listener) {
        this.mExternalSourceEventListener = listener;
    }

    @Override
    public void removeSourceEventListener() {
        this.mExternalSourceEventListener = null;
    }

    public class HeartbeatReceiver
    implements Listener<Heartbeat> {
        @Override
        public void receive(Heartbeat heartbeat) {
            AbstractChannelState.this.checkState();
        }
    }
}

