/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.channel.metadata;

import com.google.common.base.Joiner;
import io.github.dsheirer.alias.Alias;
import io.github.dsheirer.channel.metadata.ChannelAndMetadata;
import io.github.dsheirer.channel.metadata.ChannelMetadata;
import io.github.dsheirer.channel.state.State;
import io.github.dsheirer.controller.channel.Channel;
import io.github.dsheirer.controller.channel.ChannelModel;
import io.github.dsheirer.controller.channel.ChannelProcessingManager;
import io.github.dsheirer.eventbus.MyEventBus;
import io.github.dsheirer.gui.playlist.channel.ViewChannelRequest;
import io.github.dsheirer.icon.IconModel;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.identifier.configuration.FrequencyConfigurationIdentifier;
import io.github.dsheirer.identifier.decoder.ChannelStateIdentifier;
import io.github.dsheirer.module.ProcessingChain;
import io.github.dsheirer.playlist.PlaylistManager;
import io.github.dsheirer.preference.UserPreferences;
import io.github.dsheirer.preference.identifier.TalkgroupFormatPreference;
import io.github.dsheirer.preference.swing.JTableColumnWidthMonitor;
import io.github.dsheirer.sample.Broadcaster;
import io.github.dsheirer.sample.Listener;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import net.miginfocom.swing.MigLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelMetadataPanel
extends JPanel
implements ListSelectionListener {
    private static final Logger mLog = LoggerFactory.getLogger(ChannelMetadataPanel.class);
    private static final String TABLE_PREFERENCE_KEY = "channel.metadata.panel";
    private ChannelModel mChannelModel;
    private ChannelProcessingManager mChannelProcessingManager;
    private IconModel mIconModel;
    private UserPreferences mUserPreferences;
    private JTable mTable;
    private Broadcaster<ProcessingChain> mSelectedProcessingChainBroadcaster = new Broadcaster();
    private Map<State, Color> mBackgroundColors = new EnumMap<State, Color>(State.class);
    private Map<State, Color> mForegroundColors = new EnumMap<State, Color>(State.class);
    private JTableColumnWidthMonitor mTableColumnMonitor;
    private Channel mUserSelectedChannel;

    public ChannelMetadataPanel(PlaylistManager playlistManager, IconModel iconModel, UserPreferences userPreferences) {
        this.mChannelModel = playlistManager.getChannelModel();
        this.mChannelProcessingManager = playlistManager.getChannelProcessingManager();
        this.mIconModel = iconModel;
        this.mUserPreferences = userPreferences;
        this.init();
    }

    private void init() {
        this.setLayout((LayoutManager)new MigLayout("insets 0 0 0 0", "[grow,fill]", "[grow,fill]"));
        this.mTable = new JTable(this.mChannelProcessingManager.getChannelMetadataModel());
        this.mChannelProcessingManager.getChannelMetadataModel().setChannelAddListener(new ChannelAddListener());
        DefaultTableCellRenderer renderer = (DefaultTableCellRenderer)this.mTable.getDefaultRenderer(String.class);
        renderer.setHorizontalAlignment(0);
        this.mTable.getSelectionModel().addListSelectionListener(this);
        this.mTable.addMouseListener(new MouseSupport());
        this.mTable.getColumnModel().getColumn(0).setCellRenderer(new ColoredStateCellRenderer());
        this.mTable.getColumnModel().getColumn(2).setCellRenderer(new FromCellRenderer(this.mUserPreferences.getTalkgroupFormatPreference()));
        this.mTable.getColumnModel().getColumn(4).setCellRenderer(new ToCellRenderer(this.mUserPreferences.getTalkgroupFormatPreference()));
        this.mTable.getColumnModel().getColumn(3).setCellRenderer(new AliasCellRenderer());
        this.mTable.getColumnModel().getColumn(5).setCellRenderer(new AliasCellRenderer());
        this.mTable.getColumnModel().getColumn(7).setCellRenderer(new FrequencyCellRenderer());
        this.mTableColumnMonitor = new JTableColumnWidthMonitor(this.mUserPreferences, this.mTable, TABLE_PREFERENCE_KEY);
        JScrollPane scrollPane = new JScrollPane(this.mTable, 22, 30);
        this.add(scrollPane);
        this.setColors();
    }

    private void setColors() {
        this.mBackgroundColors.put(State.ACTIVE, Color.CYAN);
        this.mForegroundColors.put(State.ACTIVE, Color.BLUE);
        this.mBackgroundColors.put(State.CALL, Color.BLUE);
        this.mForegroundColors.put(State.CALL, Color.YELLOW);
        this.mBackgroundColors.put(State.CONTROL, Color.ORANGE);
        this.mForegroundColors.put(State.CONTROL, Color.BLUE);
        this.mBackgroundColors.put(State.DATA, Color.GREEN);
        this.mForegroundColors.put(State.DATA, Color.BLUE);
        this.mBackgroundColors.put(State.ENCRYPTED, Color.MAGENTA);
        this.mForegroundColors.put(State.ENCRYPTED, Color.WHITE);
        this.mBackgroundColors.put(State.FADE, Color.LIGHT_GRAY);
        this.mForegroundColors.put(State.FADE, Color.DARK_GRAY);
        this.mBackgroundColors.put(State.IDLE, Color.WHITE);
        this.mForegroundColors.put(State.IDLE, Color.DARK_GRAY);
        this.mBackgroundColors.put(State.RESET, Color.PINK);
        this.mForegroundColors.put(State.RESET, Color.YELLOW);
        this.mBackgroundColors.put(State.TEARDOWN, Color.DARK_GRAY);
        this.mForegroundColors.put(State.TEARDOWN, Color.WHITE);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (!this.mTable.getSelectionModel().getValueIsAdjusting()) {
            ProcessingChain processingChain = null;
            int selectedViewRow = this.mTable.getSelectedRow();
            if (selectedViewRow >= 0) {
                int selectedModelRow = this.mTable.convertRowIndexToModel(selectedViewRow);
                ChannelMetadata selectedMetadata = this.mChannelProcessingManager.getChannelMetadataModel().getChannelMetadata(selectedModelRow);
                if (selectedMetadata != null) {
                    this.mUserSelectedChannel = this.mChannelProcessingManager.getChannelMetadataModel().getChannelFromMetadata(selectedMetadata);
                    processingChain = this.mChannelProcessingManager.getProcessingChain(this.mUserSelectedChannel);
                }
            }
            this.mSelectedProcessingChainBroadcaster.broadcast(processingChain);
        }
    }

    public void addProcessingChainSelectionListener(Listener<ProcessingChain> listener) {
        this.mSelectedProcessingChainBroadcaster.addListener(listener);
    }

    public class ChannelAddListener
    implements Listener<ChannelAndMetadata> {
        @Override
        public void receive(ChannelAndMetadata channelAndMetadata) {
            int modelRow;
            List<ChannelMetadata> metadata;
            if (ChannelMetadataPanel.this.mUserSelectedChannel != null && ChannelMetadataPanel.this.mUserSelectedChannel.getChannelID() == channelAndMetadata.getChannel().getChannelID() && (metadata = channelAndMetadata.getChannelMetadata()).size() > 0 && (modelRow = ChannelMetadataPanel.this.mChannelProcessingManager.getChannelMetadataModel().getRow(metadata.get(0))) >= 0) {
                int tableRow = ChannelMetadataPanel.this.mTable.convertRowIndexToView(modelRow);
                ChannelMetadataPanel.this.mTable.getSelectionModel().setSelectionInterval(tableRow, tableRow);
            }
        }
    }

    public class MouseSupport
    extends MouseAdapter {
        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getButton() == 3) {
                Channel channel;
                ChannelMetadata metadata;
                int modelRowIndex;
                JPopupMenu popupMenu = new JPopupMenu();
                boolean populated = false;
                int viewRowIndex = ChannelMetadataPanel.this.mTable.rowAtPoint(e.getPoint());
                if (viewRowIndex >= 0 && (modelRowIndex = ChannelMetadataPanel.this.mTable.convertRowIndexToModel(viewRowIndex)) >= 0 && (metadata = ChannelMetadataPanel.this.mChannelProcessingManager.getChannelMetadataModel().getChannelMetadata(modelRowIndex)) != null && (channel = ChannelMetadataPanel.this.mChannelProcessingManager.getChannelMetadataModel().getChannelFromMetadata(metadata)) != null) {
                    JMenuItem viewChannel = new JMenuItem("View/Edit: " + channel.getShortTitle());
                    viewChannel.addActionListener(e2 -> MyEventBus.getGlobalEventBus().post((Object)new ViewChannelRequest(channel)));
                    popupMenu.add(viewChannel);
                    populated = true;
                }
                if (!populated) {
                    popupMenu.add(new JMenuItem("No Actions Available"));
                }
                popupMenu.show(ChannelMetadataPanel.this.mTable, e.getX(), e.getY());
            }
        }
    }

    public class ColoredStateCellRenderer
    extends DefaultTableCellRenderer {
        public ColoredStateCellRenderer() {
            this.setHorizontalAlignment(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            Color background = table.getBackground();
            Color foreground = table.getForeground();
            if (value instanceof ChannelStateIdentifier) {
                State state = (State)((Object)((ChannelStateIdentifier)value).getValue());
                label.setText(state.getDisplayValue());
                if (ChannelMetadataPanel.this.mBackgroundColors.containsKey((Object)state)) {
                    background = ChannelMetadataPanel.this.mBackgroundColors.get((Object)state);
                }
                if (ChannelMetadataPanel.this.mForegroundColors.containsKey((Object)state)) {
                    foreground = ChannelMetadataPanel.this.mForegroundColors.get((Object)state);
                }
            } else {
                this.setText("----");
            }
            this.setBackground(background);
            this.setForeground(foreground);
            return label;
        }
    }

    public class FromCellRenderer
    extends IdentifierCellRenderer {
        public FromCellRenderer(TalkgroupFormatPreference talkgroupFormatPreference) {
            super(talkgroupFormatPreference);
        }

        @Override
        public Identifier getIdentifier(ChannelMetadata channelMetadata) {
            return channelMetadata.getFromIdentifier();
        }
    }

    public class ToCellRenderer
    extends IdentifierCellRenderer {
        public ToCellRenderer(TalkgroupFormatPreference talkgroupFormatPreference) {
            super(talkgroupFormatPreference);
        }

        @Override
        public Identifier getIdentifier(ChannelMetadata channelMetadata) {
            return channelMetadata.getToIdentifier();
        }
    }

    public class AliasCellRenderer
    extends DefaultTableCellRenderer {
        public AliasCellRenderer() {
            this.setHorizontalAlignment(2);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (value instanceof List) {
                List aliases = (List)value;
                if (!aliases.isEmpty()) {
                    label.setText(Joiner.on((String)", ").skipNulls().join((Iterable)aliases));
                    label.setIcon(ChannelMetadataPanel.this.mIconModel.getIcon(((Alias)aliases.get(0)).getIconName(), 12));
                    label.setForeground(((Alias)aliases.get(0)).getDisplayColor());
                } else {
                    label.setText(null);
                    label.setIcon(null);
                    label.setForeground(table.getForeground());
                }
            } else {
                label.setText(null);
                label.setIcon(null);
                label.setForeground(table.getForeground());
            }
            return label;
        }
    }

    public class FrequencyCellRenderer
    extends DefaultTableCellRenderer {
        private final DecimalFormat FREQUENCY_FORMATTER = new DecimalFormat("#.00000");

        public FrequencyCellRenderer() {
            this.setHorizontalAlignment(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (value instanceof FrequencyConfigurationIdentifier) {
                long frequency = (Long)((FrequencyConfigurationIdentifier)value).getValue();
                label.setText(this.FREQUENCY_FORMATTER.format((double)frequency / 1000000.0));
            } else {
                label.setText(null);
            }
            return label;
        }
    }

    public abstract class IdentifierCellRenderer
    extends DefaultTableCellRenderer {
        private static final String EMPTY_VALUE = "-----";
        private TalkgroupFormatPreference mTalkgroupFormatPreference;

        public IdentifierCellRenderer(TalkgroupFormatPreference talkgroupFormatPreference) {
            this.mTalkgroupFormatPreference = talkgroupFormatPreference;
            this.setHorizontalAlignment(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (value instanceof ChannelMetadata) {
                ChannelMetadata channelMetadata = (ChannelMetadata)value;
                Identifier identifier = this.getIdentifier(channelMetadata);
                String text = this.mTalkgroupFormatPreference.format(identifier);
                if (text == null || text.isEmpty()) {
                    text = EMPTY_VALUE;
                }
                label.setText(text);
            } else {
                label.setText(EMPTY_VALUE);
            }
            return label;
        }

        public abstract Identifier getIdentifier(ChannelMetadata var1);
    }
}

