/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.buffer.airspy.hf;

import io.github.dsheirer.buffer.AbstractNativeBufferFactory;
import io.github.dsheirer.buffer.DcCorrectionManager;
import io.github.dsheirer.buffer.INativeBuffer;
import io.github.dsheirer.buffer.airspy.hf.AirspyHfNativeBuffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;

public class AirspyHfNativeBufferFactory
extends AbstractNativeBufferFactory {
    private DcCorrectionManager mDcCorrectionManager = new DcCorrectionManager();

    @Override
    public INativeBuffer getBuffer(ByteBuffer samples, long timestamp) {
        ShortBuffer shortBuffer = samples.order(ByteOrder.LITTLE_ENDIAN).asShortBuffer();
        short[] converted = new short[shortBuffer.capacity()];
        shortBuffer.get(converted);
        if (this.mDcCorrectionManager.shouldCalculateDc()) {
            this.calculateDc(converted);
        }
        return new AirspyHfNativeBuffer(timestamp, this.getSamplesPerMillisecond(), this.mDcCorrectionManager.getAverageDc(), converted);
    }

    private void calculateDc(short[] samples) {
        float dcAccumulator = 0.0f;
        for (short sample : samples) {
            dcAccumulator += (float)sample;
        }
        this.mDcCorrectionManager.adjust((dcAccumulator /= (float)samples.length) * 3.0517578E-5f);
    }
}

