/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.buffer.airspy;

import io.github.dsheirer.buffer.DcCorrectionManager;
import io.github.dsheirer.buffer.airspy.IAirspySampleConverter;
import java.nio.ByteBuffer;

public class ScalarUnpackedSampleConverter
implements IAirspySampleConverter {
    private DcCorrectionManager mDcCalculationManager = new DcCorrectionManager();

    @Override
    public short[] convert(ByteBuffer buffer) {
        boolean shouldCalculateDc = this.mDcCalculationManager.shouldCalculateDc();
        int offset = 0;
        short[] samples = new short[buffer.capacity() / 2];
        if (shouldCalculateDc) {
            long dcAccumulator = 0L;
            for (int x = 0; x < samples.length; ++x) {
                short sample;
                byte b1 = buffer.get(offset++);
                byte b2 = buffer.get(offset++);
                samples[x] = sample = (short)((b2 & 0xF) << 8 | b1 & 0xFF);
                dcAccumulator += (long)sample;
            }
            float averageDcNow = (float)dcAccumulator / (float)samples.length - 2048.0f;
            this.mDcCalculationManager.adjust(averageDcNow *= 4.8828125E-4f);
        } else {
            for (int x = 0; x < samples.length; ++x) {
                short sample;
                byte b1 = buffer.get(offset++);
                byte b2 = buffer.get(offset++);
                samples[x] = sample = (short)((b2 & 0xF) << 8 | b1 & 0xFF);
            }
        }
        return samples;
    }

    @Override
    public float getAverageDc() {
        return this.mDcCalculationManager.getAverageDc();
    }
}

