/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.buffer.airspy;

import io.github.dsheirer.dsp.filter.hilbert.HilbertTransform;
import java.util.Iterator;

public abstract class AirspyBufferIterator<T>
implements Iterator<T> {
    protected static final float SCALE_SIGNED_12_BIT_TO_FLOAT = 4.8828125E-4f;
    protected static final int FRAGMENT_SIZE = 2048;
    protected static final float[] COEFFICIENTS = HilbertTransform.convertHalfBandToHilbert(HilbertTransform.HALF_BAND_FILTER_47_TAP);
    public static final int I_OVERLAP = 11;
    public static final int Q_OVERLAP = 23;
    protected float[] mIBuffer = new float[2059];
    protected float[] mQBuffer = new float[2071];
    protected short[] mSamples;
    protected int mSamplesPointer = 0;
    protected float mAverageDc;
    private long mTimestamp;
    private float mSamplesPerMillisecond;

    public AirspyBufferIterator(short[] samples, short[] residualI, short[] residualQ, float averageDc, long timestamp, float samplesPerMillisecond) {
        if (residualI.length != 11 || residualQ.length != 23) {
            throw new IllegalArgumentException("Residual I length [" + residualI.length + "] must be 11 and Residual Q length [" + residualQ.length + "] must be 23");
        }
        int requiredInterval = 4096;
        if (samples.length % requiredInterval != 0) {
            throw new IllegalArgumentException("Samples short array length [" + this.mSamples.length + "]must be an integer multiple of " + requiredInterval);
        }
        this.mAverageDc = averageDc;
        this.mSamples = samples;
        this.mTimestamp = timestamp;
        this.mSamplesPerMillisecond = samplesPerMillisecond;
        for (int i = 0; i < residualI.length; ++i) {
            this.mIBuffer[i] = AirspyBufferIterator.scale(residualI[i], averageDc);
        }
        for (int q = 0; q < residualQ.length; ++q) {
            this.mQBuffer[q] = AirspyBufferIterator.scale(residualQ[q], averageDc);
        }
    }

    protected long getFragmentTimestamp(int samplesPointer) {
        return this.mTimestamp + (long)((float)(samplesPointer / 2) / this.mSamplesPerMillisecond);
    }

    @Override
    public boolean hasNext() {
        return this.mSamplesPointer < this.mSamples.length;
    }

    public static float scale(short value, float averageDc) {
        return ((float)value - 2048.0f) * 4.8828125E-4f - averageDc;
    }
}

