/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.buffer;

import io.github.dsheirer.sample.complex.Complex;
import java.util.Arrays;

public class ComplexCircularBuffer {
    Complex[] mBuffer;
    int mBufferPointer = 0;

    public ComplexCircularBuffer(int size) {
        this.mBuffer = new Complex[size];
        Arrays.fill(this.mBuffer, new Complex(1.0f, 1.0f));
    }

    public int length() {
        return this.mBuffer.length;
    }

    public Complex get(Complex sample) {
        Complex retVal = this.mBuffer[this.mBufferPointer];
        this.put(sample);
        return retVal;
    }

    public void put(Complex sample) {
        this.mBuffer[this.mBufferPointer] = sample;
        ++this.mBufferPointer;
        if (this.mBufferPointer >= this.mBuffer.length) {
            this.mBufferPointer = 0;
        }
    }

    public Complex[] get(int count) {
        Complex[] samples = new Complex[count];
        int tempCounter = this.mBufferPointer;
        for (int x = 0; x < count; ++x) {
            samples[x] = this.mBuffer[tempCounter];
            if (++tempCounter <= this.mBuffer.length - 1) continue;
            tempCounter = 0;
        }
        return samples;
    }

    public Complex[] getAll() {
        return this.get(this.length());
    }
}

