/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.audio.playback;

import io.github.dsheirer.audio.AudioFormats;
import io.github.dsheirer.audio.playback.AudioOutput;
import io.github.dsheirer.preference.UserPreferences;
import io.github.dsheirer.source.mixer.MixerChannel;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;
import javax.sound.sampled.Mixer;

public class MonoAudioOutput
extends AudioOutput {
    private static final int BUFFER_SIZE = 8000;

    public MonoAudioOutput(Mixer mixer, UserPreferences userPreferences) {
        super(mixer, MixerChannel.MONO, AudioFormats.PCM_SIGNED_8000_HZ_16_BIT_MONO, AudioFormats.MONO_SOURCE_DATALINE_INFO, 8000, userPreferences);
    }

    @Override
    protected ByteBuffer convert(float[] samples) {
        ByteBuffer buffer = null;
        if (samples.length > 0) {
            buffer = ByteBuffer.allocate(samples.length * 2).order(ByteOrder.LITTLE_ENDIAN);
            ShortBuffer shortBuffer = buffer.asShortBuffer();
            for (float sample : samples) {
                shortBuffer.put((short)(sample * 32767.0f));
            }
        }
        return buffer;
    }
}

