/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.audio.playback;

import com.google.common.eventbus.Subscribe;
import io.github.dsheirer.audio.AudioEvent;
import io.github.dsheirer.audio.AudioException;
import io.github.dsheirer.audio.AudioSegment;
import io.github.dsheirer.audio.IAudioController;
import io.github.dsheirer.audio.playback.AudioOutput;
import io.github.dsheirer.audio.playback.MonoAudioOutput;
import io.github.dsheirer.audio.playback.StereoAudioOutput;
import io.github.dsheirer.controller.NamingThreadFactory;
import io.github.dsheirer.eventbus.MyEventBus;
import io.github.dsheirer.preference.PreferenceType;
import io.github.dsheirer.preference.UserPreferences;
import io.github.dsheirer.sample.Broadcaster;
import io.github.dsheirer.sample.Listener;
import io.github.dsheirer.source.mixer.MixerChannel;
import io.github.dsheirer.source.mixer.MixerChannelConfiguration;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AudioPlaybackManager
implements Listener<AudioSegment>,
IAudioController {
    private static final Logger mLog = LoggerFactory.getLogger(AudioPlaybackManager.class);
    public static final AudioEvent CONFIGURATION_CHANGE_STARTED = new AudioEvent(AudioEvent.Type.AUDIO_CONFIGURATION_CHANGE_STARTED, null);
    public static final AudioEvent CONFIGURATION_CHANGE_COMPLETE = new AudioEvent(AudioEvent.Type.AUDIO_CONFIGURATION_CHANGE_COMPLETE, null);
    private Broadcaster<AudioEvent> mControllerBroadcaster = new Broadcaster();
    private ScheduledFuture<?> mProcessingTask;
    private UserPreferences mUserPreferences;
    private MixerChannelConfiguration mMixerChannelConfiguration;
    private List<AudioOutput> mAudioOutputs = new ArrayList<AudioOutput>();
    private List<AudioSegment> mAudioSegments = new ArrayList<AudioSegment>();
    private List<AudioSegment> mPendingAudioSegments = new ArrayList<AudioSegment>();
    private LinkedTransferQueue<AudioSegment> mNewAudioSegmentQueue = new LinkedTransferQueue();
    private ScheduledExecutorService mScheduledExecutorService = Executors.newSingleThreadScheduledExecutor(new NamingThreadFactory("sdrtrunk audio manager"));

    public AudioPlaybackManager(UserPreferences userPreferences) {
        this.mUserPreferences = userPreferences;
        MyEventBus.getGlobalEventBus().register((Object)this);
        MixerChannelConfiguration configuration = this.mUserPreferences.getPlaybackPreference().getMixerChannelConfiguration();
        if (configuration != null) {
            try {
                this.setMixerChannelConfiguration(configuration);
            }
            catch (AudioException ae) {
                mLog.error("Error during setup of audio playback configuration.  Attempted to use audio mixer [" + (configuration != null ? configuration.getMixer().toString() : "null") + "] and channel [" + (configuration != null ? configuration.getMixerChannel().name() : "null") + "]", (Throwable)ae);
            }
        } else {
            mLog.warn("No audio output devices available");
        }
    }

    @Override
    public void receive(AudioSegment audioSegment) {
        this.mNewAudioSegmentQueue.add(audioSegment);
    }

    private void processAudioSegments() {
        AudioSegment audioSegment;
        Iterator<AudioSegment> it;
        AudioSegment newSegment = this.mNewAudioSegmentQueue.poll();
        while (newSegment != null) {
            if (newSegment.isDuplicate() && this.mUserPreferences.getDuplicateCallDetectionPreference().isDuplicatePlaybackSuppressionEnabled()) {
                newSegment.decrementConsumerCount();
            } else if (newSegment.hasAudio()) {
                this.mAudioSegments.add(newSegment);
            } else {
                this.mPendingAudioSegments.add(newSegment);
            }
            newSegment = this.mNewAudioSegmentQueue.poll();
        }
        if (!this.mPendingAudioSegments.isEmpty()) {
            it = this.mPendingAudioSegments.iterator();
            while (it.hasNext()) {
                audioSegment = it.next();
                if (audioSegment.isDuplicate() && this.mUserPreferences.getDuplicateCallDetectionPreference().isDuplicatePlaybackSuppressionEnabled()) {
                    it.remove();
                    audioSegment.decrementConsumerCount();
                    continue;
                }
                if (audioSegment.hasAudio()) {
                    it.remove();
                    this.mAudioSegments.add(audioSegment);
                    continue;
                }
                if (!audioSegment.completeProperty().get()) continue;
                it.remove();
                audioSegment.decrementConsumerCount();
            }
        }
        if (!this.mAudioSegments.isEmpty()) {
            it = this.mAudioSegments.iterator();
            while (it.hasNext()) {
                audioSegment = it.next();
                if (audioSegment.isDoNotMonitor() || audioSegment.isDuplicate() && this.mUserPreferences.getDuplicateCallDetectionPreference().isDuplicatePlaybackSuppressionEnabled()) {
                    it.remove();
                    audioSegment.decrementConsumerCount();
                    continue;
                }
                if (!audioSegment.isLinked()) continue;
                for (AudioOutput audioOutput : this.mAudioOutputs) {
                    if (!audioOutput.isLinkedTo(audioSegment)) continue;
                    it.remove();
                    audioOutput.play(audioSegment);
                }
            }
            if (!this.mAudioSegments.isEmpty()) {
                this.mAudioSegments.sort(Comparator.comparingInt(o -> o.monitorPriorityProperty().get()));
                for (AudioOutput audioOutput : this.mAudioOutputs) {
                    if (!audioOutput.isEmpty()) continue;
                    audioOutput.play(this.mAudioSegments.remove(0));
                    if (!this.mAudioSegments.isEmpty()) continue;
                    return;
                }
            }
            it = this.mAudioSegments.iterator();
            while (it.hasNext()) {
                audioSegment = it.next();
                if (!audioSegment.completeProperty().get() && (!audioSegment.isDuplicate() || !this.mUserPreferences.getDuplicateCallDetectionPreference().isDuplicatePlaybackSuppressionEnabled())) continue;
                it.remove();
                audioSegment.decrementConsumerCount();
            }
        }
    }

    public void dispose() {
        MyEventBus.getGlobalEventBus().unregister((Object)this);
        if (this.mProcessingTask != null) {
            this.mProcessingTask.cancel(true);
            this.mProcessingTask = null;
        }
        this.mNewAudioSegmentQueue.clear();
        this.mAudioSegments.clear();
    }

    @Subscribe
    public void preferenceUpdated(PreferenceType preferenceType) {
        MixerChannelConfiguration configuration;
        if (preferenceType == PreferenceType.PLAYBACK && (configuration = this.mUserPreferences.getPlaybackPreference().getMixerChannelConfiguration()) != null && !configuration.equals(this.mMixerChannelConfiguration)) {
            try {
                this.setMixerChannelConfiguration(configuration);
            }
            catch (AudioException ae) {
                mLog.error("Error changing audio output to [" + String.valueOf(configuration) + "]", (Throwable)ae);
            }
        }
    }

    @Override
    public void setMixerChannelConfiguration(MixerChannelConfiguration entry) throws AudioException {
        if (entry != null) {
            this.mControllerBroadcaster.broadcast(CONFIGURATION_CHANGE_STARTED);
            if (this.mProcessingTask != null) {
                this.mProcessingTask.cancel(true);
            }
            for (AudioOutput audioOutput : this.mAudioOutputs) {
                audioOutput.dispose();
            }
            this.mAudioOutputs.clear();
            switch (entry.getMixerChannel()) {
                case MONO: {
                    MonoAudioOutput mono = new MonoAudioOutput(entry.getMixer(), this.mUserPreferences);
                    this.mAudioOutputs.add(mono);
                    break;
                }
                case STEREO: {
                    StereoAudioOutput left = new StereoAudioOutput(entry.getMixer(), MixerChannel.LEFT, this.mUserPreferences);
                    this.mAudioOutputs.add(left);
                    StereoAudioOutput right = new StereoAudioOutput(entry.getMixer(), MixerChannel.RIGHT, this.mUserPreferences);
                    this.mAudioOutputs.add(right);
                    break;
                }
                default: {
                    throw new AudioException("Unsupported mixer channel configuration: " + String.valueOf((Object)entry.getMixerChannel()));
                }
            }
            this.mProcessingTask = this.mScheduledExecutorService.scheduleAtFixedRate(new AudioSegmentProcessor(), 0L, 100L, TimeUnit.MILLISECONDS);
            this.mControllerBroadcaster.broadcast(CONFIGURATION_CHANGE_COMPLETE);
            this.mMixerChannelConfiguration = entry;
        }
    }

    @Override
    public MixerChannelConfiguration getMixerChannelConfiguration() {
        return this.mMixerChannelConfiguration;
    }

    @Override
    public List<AudioOutput> getAudioOutputs() {
        ArrayList<AudioOutput> outputs = new ArrayList<AudioOutput>(this.mAudioOutputs);
        outputs.sort(Comparator.comparing(AudioOutput::getChannelName));
        return outputs;
    }

    @Override
    public void addControllerListener(Listener<AudioEvent> listener) {
        this.mControllerBroadcaster.addListener(listener);
    }

    @Override
    public void removeControllerListener(Listener<AudioEvent> listener) {
        this.mControllerBroadcaster.removeListener(listener);
    }

    public class AudioSegmentProcessor
    implements Runnable {
        private AtomicBoolean mProcessing = new AtomicBoolean();

        @Override
        public void run() {
            if (this.mProcessing.compareAndSet(false, true)) {
                try {
                    AudioPlaybackManager.this.processAudioSegments();
                }
                catch (Throwable t) {
                    mLog.error("Encountered error while processing audio segments", t);
                }
                this.mProcessing.set(false);
            }
        }
    }
}

