/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.audio.invert;

import io.github.dsheirer.audio.invert.InversionFrequency;
import io.github.dsheirer.dsp.filter.FloatFIRFilter;
import io.github.dsheirer.dsp.oscillator.IRealOscillator;
import io.github.dsheirer.dsp.oscillator.OscillatorFactory;
import io.github.dsheirer.sample.real.RealSampleListener;

public class AudioInverter
implements RealSampleListener {
    private static final float[] LOW_PASS_FILTER = new float[]{-0.005241979f, -3.7899095E-4f, 0.0012970138f, 0.0042104605f, 0.008221266f, 0.012951576f, 0.017794313f, 0.021959871f, 0.0245838f, 0.024878144f, 0.022296319f, 0.016685495f, 0.008390268f, -0.0017182644f, -0.01228839f, -0.021616332f, -0.027882129f, -0.029433772f, -0.025006516f, -0.014040075f, 0.0032217507f, 0.025660032f, 0.0513601f, 0.07783361f, 0.102309264f, 0.122099616f, 0.13496813f, 0.13943118f, 0.13496813f, 0.122099616f, 0.102309264f, 0.07783361f, 0.0513601f, 0.025660032f, 0.0032217507f, -0.014040075f, -0.025006516f, -0.029433772f, -0.027882129f, -0.021616332f, -0.01228839f, -0.0017182644f, 0.008390268f, 0.016685495f, 0.022296319f, 0.024878144f, 0.0245838f, 0.021959871f, 0.017794313f, 0.012951576f, 0.008221266f, 0.0042104605f, 0.0012970138f, -3.7899095E-4f, -0.005241979f};
    private IRealOscillator mSineWaveGenerator;
    private FloatFIRFilter mPostInversionLowPassFilter;
    private RealSampleListener mListener;

    public AudioInverter(int inversionFrequency, int sampleRate) {
        this.mSineWaveGenerator = OscillatorFactory.getRealOscillator(inversionFrequency, sampleRate);
        this.mPostInversionLowPassFilter = new FloatFIRFilter(LOW_PASS_FILTER, 1.04f);
        this.mPostInversionLowPassFilter.setListener(new FilteredSampleProcessor());
    }

    public AudioInverter(InversionFrequency frequency, int sampleRate) {
        this(frequency.getFrequency(), sampleRate);
    }

    public void setListener(RealSampleListener listener) {
        this.mListener = listener;
    }

    @Override
    public void receive(float sample) {
        if (this.mPostInversionLowPassFilter != null) {
            this.mPostInversionLowPassFilter.receive(sample * this.mSineWaveGenerator.generate(1)[0]);
        }
    }

    class FilteredSampleProcessor
    implements RealSampleListener {
        FilteredSampleProcessor() {
        }

        @Override
        public void receive(float sample) {
            if (AudioInverter.this.mListener != null) {
                AudioInverter.this.mListener.receive(sample);
            }
        }
    }
}

