/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.audio.convert.thumbdv.message;

public enum PacketField {
    PKT_ENCODER_CMODE(5),
    PKT_DECODER_CMODE(6),
    PKT_RATE_TABLE(9),
    PKT_RATE_PARAMETER(10),
    PKT_INIT(11),
    PKT_LOW_POWER(16),
    PKT_CHANNEL_FORMAT(21),
    PKT_SPEECH_FORMAT(22),
    PKT_CODEC_START(42),
    PKT_CODEC_STOP(43),
    PKT_PRODUCT_ID(48),
    PKT_VERSION_STRING(49),
    PKT_COMPAND(50),
    PKT_RESET(51),
    PKT_RESET_TO_SOFTWARE_CONFIG(52),
    PKT_HALT(53),
    PKT_GET_CONFIG(54),
    PKT_READ_CONFIG(55),
    PKT_CODEC_CFG(56),
    PKT_READY(57),
    PKT_PARITY_MODE(63),
    PKT_CHANNEL_0(64),
    PKT_WRITE_I2C(68),
    PKT_CLEAR_CODEC_RESET(70),
    PKT_SET_CODEC_RESET(71),
    PKT_DISCARD_CODEC_SAMPLES(72),
    PKT_DELAY_NUMBER_MICRO_SECONDS(73),
    PKT_DELAY_NUMBER_NANO_SECONDS(74),
    PKT_GAIN(75),
    PKT_RTS_THRESHOLD(78),
    SPEECH_DATA(0),
    CHANNEL_DATA_HARD_SYMBOL(1),
    CMODE(2),
    SAMPLE_COUNT(3),
    TONE(8),
    CHANNEL_DATA_SOFT_SYMBOL(23),
    VOCODER(64),
    PACKET_TYPE_CONTROL(0),
    PACKET_TYPE_ENCODE_SPEECH(1),
    PACKET_TYPE_DECODE_SPEECH(2),
    UNKNOWN(0);

    private byte mCode;

    private PacketField(byte code) {
        this.mCode = code;
    }

    public byte getCode() {
        return this.mCode;
    }

    public static PacketField fromValue(byte value) {
        switch (value) {
            case 5: {
                return PKT_ENCODER_CMODE;
            }
            case 6: {
                return PKT_DECODER_CMODE;
            }
            case 9: {
                return PKT_RATE_TABLE;
            }
            case 10: {
                return PKT_RATE_PARAMETER;
            }
            case 11: {
                return PKT_INIT;
            }
            case 16: {
                return PKT_LOW_POWER;
            }
            case 21: {
                return PKT_CHANNEL_FORMAT;
            }
            case 22: {
                return PKT_SPEECH_FORMAT;
            }
            case 42: {
                return PKT_CODEC_START;
            }
            case 43: {
                return PKT_CODEC_STOP;
            }
            case 48: {
                return PKT_PRODUCT_ID;
            }
            case 49: {
                return PKT_VERSION_STRING;
            }
            case 50: {
                return PKT_COMPAND;
            }
            case 51: {
                return PKT_RESET;
            }
            case 52: {
                return PKT_RESET_TO_SOFTWARE_CONFIG;
            }
            case 53: {
                return PKT_HALT;
            }
            case 54: {
                return PKT_GET_CONFIG;
            }
            case 55: {
                return PKT_READ_CONFIG;
            }
            case 56: {
                return PKT_CODEC_CFG;
            }
            case 57: {
                return PKT_READY;
            }
            case 63: {
                return PKT_PARITY_MODE;
            }
            case 64: {
                return PKT_CHANNEL_0;
            }
            case 68: {
                return PKT_WRITE_I2C;
            }
            case 70: {
                return PKT_CLEAR_CODEC_RESET;
            }
            case 71: {
                return PKT_SET_CODEC_RESET;
            }
            case 72: {
                return PKT_DISCARD_CODEC_SAMPLES;
            }
            case 73: {
                return PKT_DELAY_NUMBER_MICRO_SECONDS;
            }
            case 74: {
                return PKT_DELAY_NUMBER_NANO_SECONDS;
            }
            case 75: {
                return PKT_GAIN;
            }
            case 78: {
                return PKT_RTS_THRESHOLD;
            }
        }
        return UNKNOWN;
    }
}

