/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.audio.convert;

import io.github.dsheirer.audio.convert.MP3AudioFrames;
import io.github.dsheirer.audio.convert.MP3Header;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.math3.util.FastMath;

public class MP3FrameTools {
    private MP3FrameTools() {
    }

    public static MP3AudioFrames split(byte[] input) {
        ArrayList<byte[]> mp3Frames = new ArrayList<byte[]>();
        int audioDuration = 0;
        int offset = 0;
        while (offset < input.length) {
            if (MP3Header.hasSync(input, offset)) {
                int framelen = MP3Header.getFrameLength(input, offset);
                mp3Frames.add(Arrays.copyOfRange(input, offset, offset + FastMath.min((int)framelen, (int)(input.length - offset))));
                audioDuration += MP3Header.getFrameDuration(input, offset);
                offset += framelen;
                continue;
            }
            ++offset;
        }
        return new MP3AudioFrames(audioDuration, mp3Frames);
    }
}

