/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.audio.convert;

import io.github.dsheirer.audio.convert.MPEGVersion;

public class MP3BitRate {
    private static final int[] MPEG_1_L3 = new int[]{0, 32, 40, 48, 56, 64, 80, 96, 112, 128, 160, 192, 224, 256, 320};
    private static final int[] MPEG_2_L3 = new int[]{0, 8, 16, 24, 32, 40, 48, 56, 64, 80, 96, 112, 128, 144, 160};
    private static final int[] MPEG_2_5_L3 = new int[]{0, 8, 16, 24, 32, 40, 48, 56, 64};

    public static int getLayer3BitRate(MPEGVersion version, int value) {
        switch (version) {
            case V_1: {
                if (0 > value || value >= MPEG_1_L3.length) break;
                return MPEG_1_L3[value];
            }
            case V_2: {
                if (0 > value || value >= MPEG_2_L3.length) break;
                return MPEG_2_L3[value];
            }
            case V_2_5: {
                if (0 > value || value >= MPEG_2_5_L3.length) break;
                return MPEG_2_5_L3[value];
            }
        }
        return 0;
    }
}

