/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.audio.convert;

import io.github.dsheirer.audio.AudioUtils;
import io.github.dsheirer.audio.convert.IAudioConverter;
import io.github.dsheirer.audio.convert.InputAudioFormat;
import io.github.dsheirer.audio.convert.LameFactory;
import io.github.dsheirer.audio.convert.MP3Setting;
import io.github.dsheirer.dsp.filter.resample.RealResampler;
import io.github.dsheirer.sample.ConversionUtils;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.sourceforge.lame.lowlevel.LameEncoder;
import org.apache.commons.math3.util.FastMath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MP3AudioConverter
implements IAudioConverter {
    private static final Logger mLog = LoggerFactory.getLogger(MP3AudioConverter.class);
    public static final int AUDIO_QUALITY = 7;
    private LameEncoder mEncoder;
    private RealResampler mResampler;
    private ByteArrayOutputStream mMP3EncodedFramesStream = new ByteArrayOutputStream();
    private byte[] mOutputFramesBuffer;
    private InputAudioFormat mInputAudioFormat;
    private boolean mNormalizeAudio;

    public MP3AudioConverter(InputAudioFormat inputAudioFormat, MP3Setting setting, boolean normalizeAudio) {
        this.mInputAudioFormat = inputAudioFormat;
        this.mEncoder = LameFactory.getLameEncoder(inputAudioFormat, setting);
        this.mNormalizeAudio = normalizeAudio;
        if (this.mInputAudioFormat.getSampleRate() - (double)this.mEncoder.getEffectiveSampleRate() > 1.0) {
            this.mInputAudioFormat = InputAudioFormat.getDefault();
            mLog.warn("MP3 setting [" + String.valueOf((Object)setting) + "] does not support requested input audio sample rate [" + String.valueOf((Object)inputAudioFormat) + "] - using default sample rate [" + String.valueOf((Object)this.mInputAudioFormat) + "]");
            this.mEncoder = LameFactory.getLameEncoder(inputAudioFormat, setting);
        }
        if (this.mInputAudioFormat != InputAudioFormat.SR_8000 && this.mInputAudioFormat != InputAudioFormat.SR_32_8000) {
            this.mResampler = LameFactory.getResampler(inputAudioFormat);
        }
        this.mOutputFramesBuffer = new byte[this.mEncoder.getPCMBufferSize()];
    }

    @Override
    public List<byte[]> convert(List<float[]> audioPackets) {
        ArrayList<byte[]> converted = new ArrayList<byte[]>();
        if (this.mNormalizeAudio) {
            audioPackets = AudioUtils.normalize(audioPackets);
        }
        if (this.mResampler != null) {
            audioPackets = this.mResampler.resample(audioPackets);
        }
        for (int x = 0; x < audioPackets.size(); ++x) {
            byte[] bytesToEncode = null;
            bytesToEncode = this.mInputAudioFormat.getAudioFormat().getSampleSizeInBits() == 16 ? ConversionUtils.convertToSigned16BitSamples(audioPackets.get(x)).array() : ConversionUtils.convertToSigned32BitSamples(audioPackets.get(x)).array();
            int bytesToEncodePointer = 0;
            int inputChunkSize = FastMath.min((int)this.mOutputFramesBuffer.length, (int)bytesToEncode.length);
            int outputChunkSize = 0;
            try {
                while (bytesToEncodePointer < bytesToEncode.length) {
                    outputChunkSize = this.mEncoder.encodeBuffer(bytesToEncode, bytesToEncodePointer, inputChunkSize, this.mOutputFramesBuffer);
                    inputChunkSize = FastMath.min((int)this.mOutputFramesBuffer.length, (int)(bytesToEncode.length - (bytesToEncodePointer += inputChunkSize)));
                    if (outputChunkSize <= 0) continue;
                    converted.add(Arrays.copyOf(this.mOutputFramesBuffer, outputChunkSize));
                }
                continue;
            }
            catch (Exception e) {
                mLog.error("There was an error converting audio to MP3: " + e.getMessage());
            }
        }
        int finalChunkSize = this.mEncoder.encodeFinish(this.mOutputFramesBuffer);
        if (finalChunkSize > 0) {
            converted.add(Arrays.copyOf(this.mOutputFramesBuffer, finalChunkSize));
        }
        return converted;
    }

    @Override
    public List<byte[]> flush() {
        int length;
        byte[] lastPartialFrame = new byte[this.mEncoder.getMP3BufferSize()];
        byte[] frame = Arrays.copyOf(lastPartialFrame, length = this.mEncoder.encodeFinish(lastPartialFrame));
        if (frame.length == 0) {
            return Collections.emptyList();
        }
        return Collections.singletonList(frame);
    }
}

