/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.audio.convert;

import io.github.dsheirer.audio.convert.InputAudioFormat;
import io.github.dsheirer.audio.convert.MP3Setting;
import io.github.dsheirer.dsp.filter.resample.RealResampler;
import net.sourceforge.lame.lowlevel.LameEncoder;
import net.sourceforge.lame.mp3.MPEGMode;

public class LameFactory {
    public static LameEncoder getLameEncoder(InputAudioFormat input, MP3Setting setting) {
        return switch (setting) {
            case MP3Setting.CBR_16 -> new LameEncoder(input.getAudioFormat(), 16, MPEGMode.MONO, LameEncoder.DEFAULT_QUALITY, false);
            case MP3Setting.CBR_32 -> new LameEncoder(input.getAudioFormat(), 32, MPEGMode.MONO, LameEncoder.DEFAULT_QUALITY, false);
            case MP3Setting.ABR_56 -> new LameEncoder(input.getAudioFormat(), 56, MPEGMode.MONO, LameEncoder.DEFAULT_QUALITY, true);
            case MP3Setting.VBR_5 -> new LameEncoder(input.getAudioFormat(), LameEncoder.DEFAULT_BITRATE, MPEGMode.MONO, 5, true);
            case MP3Setting.VBR_7 -> new LameEncoder(input.getAudioFormat(), LameEncoder.DEFAULT_BITRATE, MPEGMode.MONO, 7, true);
            default -> throw new IllegalArgumentException("Unrecognized MP3 setting: " + String.valueOf((Object)setting));
        };
    }

    public static RealResampler getResampler(InputAudioFormat sampleRate) {
        return switch (sampleRate) {
            case InputAudioFormat.SR_16000, InputAudioFormat.SR_32_16000 -> new RealResampler(8000.0, 16000.0, 4096, 512);
            case InputAudioFormat.SR_22050, InputAudioFormat.SR_32_22050 -> new RealResampler(8000.0, 22050.0, 4096, 512);
            case InputAudioFormat.SR_44100, InputAudioFormat.SR_32_44100 -> new RealResampler(8000.0, 44100.0, 4096, 512);
            default -> throw new IllegalArgumentException("Unrecognized sample rate for resampling: " + String.valueOf((Object)sampleRate));
        };
    }
}

