/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.audio.convert;

import java.util.List;
import org.apache.commons.math3.util.FastMath;

public abstract class AudioFrames {
    protected final int audioDuration;
    protected final List<byte[]> audioFrames;
    protected int mCurrentFrame = -1;

    public AudioFrames(int audioDuration, List<byte[]> audioFrames) {
        this.audioDuration = audioDuration;
        this.audioFrames = audioFrames;
    }

    public int getDuration() {
        return this.audioDuration;
    }

    public List<byte[]> getFrames() {
        return this.audioFrames;
    }

    public byte[] getCurrentFrame() {
        return this.audioFrames.get(this.mCurrentFrame);
    }

    public abstract int getCurrentFrameDuration();

    public boolean hasPrevFrame() {
        int prevFrame = this.mCurrentFrame - 1;
        return prevFrame >= 0 && prevFrame < this.audioFrames.size();
    }

    public boolean hasNextFrame() {
        int nextFrame = this.mCurrentFrame + 1;
        return nextFrame >= 0 && nextFrame < this.audioFrames.size();
    }

    public void prevFrame() {
        --this.mCurrentFrame;
    }

    public void nextFrame() {
        ++this.mCurrentFrame;
    }

    public void restart() {
        this.mCurrentFrame = -1;
    }

    public void seek(int duration_ms) {
        int step = duration_ms < 0 ? -1 : 1;
        int actual_ms = 0;
        while (FastMath.abs((int)actual_ms) < FastMath.abs((int)duration_ms)) {
            this.mCurrentFrame += step;
            actual_ms += this.getCurrentFrameDuration();
        }
    }
}

