/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.audio.codec.mbe;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.dsheirer.alias.AliasList;
import io.github.dsheirer.audio.AudioSegment;
import io.github.dsheirer.audio.codec.mbe.MBECallSequence;
import io.github.dsheirer.identifier.IdentifierUpdateNotification;
import io.github.dsheirer.module.decode.p25.audio.P25P1AudioModule;
import io.github.dsheirer.module.decode.p25.audio.VoiceFrame;
import io.github.dsheirer.module.decode.p25.identifier.radio.APCO25RadioIdentifier;
import io.github.dsheirer.module.decode.p25.identifier.talkgroup.APCO25Talkgroup;
import io.github.dsheirer.preference.UserPreferences;
import io.github.dsheirer.record.AudioSegmentRecorder;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import jmbe.iface.IAudioCodec;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MBECallSequenceConverter {
    private static final Logger mLog = LoggerFactory.getLogger(MBECallSequenceConverter.class);

    public static void convert(Path input, Path output) throws IOException {
        InputStream inputStream = Files.newInputStream(input, new OpenOption[0]);
        ObjectMapper mapper = new ObjectMapper();
        MBECallSequence sequence = (MBECallSequence)mapper.readValue(inputStream, MBECallSequence.class);
        MBECallSequenceConverter.convert(sequence, output);
    }

    public static void convert(MBECallSequence callSequence, Path outputPath) {
        if (callSequence == null || callSequence.isEncrypted()) {
            throw new IllegalArgumentException("Cannot decode null or encrypted call sequence");
        }
        if (callSequence != null && callSequence.getProtocol().equals("APCO25-PHASE1")) {
            P25P1AudioModule audioModule = new P25P1AudioModule(new UserPreferences(), new AliasList("mbe generator"));
            audioModule.setRecordAudio(true);
            audioModule.start();
            if (callSequence.getFromIdentifier() != null) {
                int from = 0;
                try {
                    from = Integer.parseInt(callSequence.getFromIdentifier());
                    audioModule.getIdentifierUpdateListener().receive(new IdentifierUpdateNotification(APCO25RadioIdentifier.createFrom(from), IdentifierUpdateNotification.Operation.ADD, 0));
                }
                catch (Exception e) {
                    mLog.error("Error parsing from identifier from value [" + callSequence.getFromIdentifier());
                }
            }
            if (callSequence.getToIdentifier() != null) {
                int to = 0;
                try {
                    to = Integer.parseInt(callSequence.getToIdentifier());
                    audioModule.getIdentifierUpdateListener().receive(new IdentifierUpdateNotification(APCO25Talkgroup.create(to), IdentifierUpdateNotification.Operation.ADD, 0));
                }
                catch (Exception e) {
                    mLog.error("Error parsing from identifier from value [" + callSequence.getFromIdentifier());
                }
            }
            IAudioCodec codec = audioModule.getAudioCodec();
            for (VoiceFrame voiceFrame : callSequence.getVoiceFrames()) {
                byte[] frameBytes = voiceFrame.getFrameBytes();
                float[] audio = codec.getAudio(frameBytes);
                audioModule.addAudio(audio);
            }
            AudioSegment audioSegment = audioModule.getAudioSegment();
            try {
                AudioSegmentRecorder.recordWAVE(audioSegment, outputPath);
            }
            catch (IOException ioe) {
                mLog.error("Error writing audio segment, ioe");
            }
            audioModule.stop();
        }
    }

    public static void main(String[] args) {
        boolean all = true;
        String path = "/home/denny/SDRTrunk/recordings";
        Path input = Paths.get(path, new String[0]);
        if (all) {
            Collection mbeFiles = FileUtils.listFiles((File)input.toFile(), (IOFileFilter)new SuffixFileFilter(".mbe"), (IOFileFilter)DirectoryFileFilter.DIRECTORY);
            for (File inputFile : mbeFiles) {
                Path output = Paths.get(inputFile.getAbsolutePath().replace(".mbe", ".wav"), new String[0]);
                mLog.info("Converting: " + String.valueOf(inputFile));
                try {
                    MBECallSequenceConverter.convert(inputFile.toPath(), output);
                }
                catch (IOException ioe) {
                    mLog.error("Error", (Throwable)ioe);
                }
            }
        } else {
            Path output = Paths.get(path.replace(".mbe", ".wav"), new String[0]);
            mLog.info("Converting: " + path);
            try {
                MBECallSequenceConverter.convert(input, output);
            }
            catch (IOException ioe) {
                mLog.error("Error", (Throwable)ioe);
            }
        }
    }
}

