/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.audio.broadcast.shoutcast.v2.ultravox;

import io.github.dsheirer.audio.broadcast.shoutcast.v2.ultravox.AuthenticateBroadcast;
import io.github.dsheirer.audio.broadcast.shoutcast.v2.ultravox.CacheableXMLMetadata;
import io.github.dsheirer.audio.broadcast.shoutcast.v2.ultravox.ConfigureIcyGenre;
import io.github.dsheirer.audio.broadcast.shoutcast.v2.ultravox.ConfigureIcyName;
import io.github.dsheirer.audio.broadcast.shoutcast.v2.ultravox.ConfigureIcyPublic;
import io.github.dsheirer.audio.broadcast.shoutcast.v2.ultravox.ConfigureIcyURL;
import io.github.dsheirer.audio.broadcast.shoutcast.v2.ultravox.FlushCachedMetadata;
import io.github.dsheirer.audio.broadcast.shoutcast.v2.ultravox.MP3Audio;
import io.github.dsheirer.audio.broadcast.shoutcast.v2.ultravox.NegotiateBufferSize;
import io.github.dsheirer.audio.broadcast.shoutcast.v2.ultravox.NegotiateMaxPayloadSize;
import io.github.dsheirer.audio.broadcast.shoutcast.v2.ultravox.PassThroughXMLMetadata;
import io.github.dsheirer.audio.broadcast.shoutcast.v2.ultravox.RequestCipher;
import io.github.dsheirer.audio.broadcast.shoutcast.v2.ultravox.SetupBroadcast;
import io.github.dsheirer.audio.broadcast.shoutcast.v2.ultravox.Standby;
import io.github.dsheirer.audio.broadcast.shoutcast.v2.ultravox.StreamMimeType;
import io.github.dsheirer.audio.broadcast.shoutcast.v2.ultravox.TerminateBroadcast;
import io.github.dsheirer.audio.broadcast.shoutcast.v2.ultravox.UltravoxMessage;
import io.github.dsheirer.audio.broadcast.shoutcast.v2.ultravox.UltravoxMessageType;

public class UltravoxMessageFactory {
    public static UltravoxMessage getMessage(UltravoxMessageType type) {
        switch (type) {
            case AUTHENTICATE_BROADCAST: {
                return new AuthenticateBroadcast();
            }
            case CACHEABLE_XML_METADATA: {
                return new CacheableXMLMetadata();
            }
            case CONFIGURE_ICY_GENRE: {
                return new ConfigureIcyGenre();
            }
            case CONFIGURE_ICY_NAME: {
                return new ConfigureIcyName();
            }
            case CONFIGURE_ICY_PUBLIC: {
                return new ConfigureIcyPublic();
            }
            case CONFIGURE_ICY_URL: {
                return new ConfigureIcyURL();
            }
            case FLUSH_CACHED_METADATA: {
                return new FlushCachedMetadata();
            }
            case MP3_DATA: {
                return new MP3Audio();
            }
            case NEGOTIATE_BUFFER_SIZE: {
                return new NegotiateBufferSize();
            }
            case NEGOTIATE_MAX_PAYLOAD_SIZE: {
                return new NegotiateMaxPayloadSize();
            }
            case PASS_THROUGH_XML_METADATA: {
                return new PassThroughXMLMetadata();
            }
            case REQUEST_CIPHER: {
                return new RequestCipher();
            }
            case SETUP_BROADCAST: {
                return new SetupBroadcast();
            }
            case STANDBY: {
                return new Standby();
            }
            case STREAM_MIME_TYPE: {
                return new StreamMimeType();
            }
            case TERMINATE_BROADCAST: {
                return new TerminateBroadcast();
            }
        }
        return null;
    }

    public static UltravoxMessage getMessage(byte[] bytes) {
        UltravoxMessageType type = UltravoxMessageFactory.getMessageType(bytes);
        switch (type) {
            case AUTHENTICATE_BROADCAST: {
                return new AuthenticateBroadcast(bytes);
            }
            case CACHEABLE_XML_METADATA: {
                return new CacheableXMLMetadata(bytes);
            }
            case CONFIGURE_ICY_GENRE: {
                return new ConfigureIcyGenre(bytes);
            }
            case CONFIGURE_ICY_NAME: {
                return new ConfigureIcyName(bytes);
            }
            case CONFIGURE_ICY_PUBLIC: {
                return new ConfigureIcyPublic(bytes);
            }
            case CONFIGURE_ICY_URL: {
                return new ConfigureIcyURL(bytes);
            }
            case FLUSH_CACHED_METADATA: {
                return new FlushCachedMetadata(bytes);
            }
            case MP3_DATA: {
                return new MP3Audio(bytes);
            }
            case NEGOTIATE_BUFFER_SIZE: {
                return new NegotiateBufferSize(bytes);
            }
            case NEGOTIATE_MAX_PAYLOAD_SIZE: {
                return new NegotiateMaxPayloadSize(bytes);
            }
            case PASS_THROUGH_XML_METADATA: {
                return new PassThroughXMLMetadata(bytes);
            }
            case REQUEST_CIPHER: {
                return new RequestCipher(bytes);
            }
            case SETUP_BROADCAST: {
                return new SetupBroadcast(bytes);
            }
            case STANDBY: {
                return new Standby(bytes);
            }
            case STREAM_MIME_TYPE: {
                return new StreamMimeType(bytes);
            }
            case TERMINATE_BROADCAST: {
                return new TerminateBroadcast(bytes);
            }
        }
        return null;
    }

    private static UltravoxMessageType getMessageType(byte[] data) {
        if (data != null && data.length > 4) {
            int value = (data[2] << 8) + data[3];
            return UltravoxMessageType.fromValue(value);
        }
        return UltravoxMessageType.UNKNOWN;
    }
}

